/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.file;

import java.io.File;
import org.apache.commons.lang3.ArrayUtils;

public class DirUtil {
    public static final boolean mkdirsIfAbsent(String pathname) {
        File file = new File(pathname);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static final boolean isDir(String pathname) {
        File file = new File(pathname);
        if (!file.exists()) {
            return false;
        }
        return file.isDirectory();
    }

    public static final boolean delete(String pathname, boolean recursive) {
        File file = new File(pathname);
        return DirUtil.delete(file, recursive);
    }

    public static final boolean delete(File file, boolean recursive) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ArrayUtils.isEmpty((Object[])files)) {
                return file.delete();
            }
            if (recursive) {
                for (Object f : files) {
                    DirUtil.delete((File)f, true);
                }
                return file.delete();
            }
            return false;
        }
        return file.delete();
    }
}

