/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.niolex.commons.bean.Pair;
import org.apache.niolex.commons.collection.CollectionUtil;
import org.apache.niolex.commons.file.FileMonitor;

public class DirMonitor
extends FileMonitor
implements FileMonitor.EventListener {
    protected List<String> fileList;
    protected Boolean isDir;

    public DirMonitor(int monitorInterval, String filePathName) {
        super(monitorInterval, filePathName);
        this.addListener(this);
    }

    @Override
    public void notify(FileMonitor.EventType type, long happenTime) {
        if (type == FileMonitor.EventType.CREATE || type == FileMonitor.EventType.UPDATE) {
            if (this.isDir == null) {
                this.checkCreate();
            } else if (this.isDir == Boolean.TRUE) {
                this.checkUpdate();
            }
        } else if (type == FileMonitor.EventType.DELETE) {
            this.checkDelete();
        }
    }

    private void checkCreate() {
        this.isDir = this.file.isDirectory();
        if (this.isDir == Boolean.FALSE) {
            this.notifyChildrenListeners(FileMonitor.EventType.NOT_DIR, null);
        } else {
            this.fileList = Arrays.asList(this.file.list());
            if (this.fileList.size() > 0) {
                this.notifyChildrenListeners(FileMonitor.EventType.ADD_CHILDREN, Collections.unmodifiableList(this.fileList));
            }
        }
    }

    private void checkUpdate() {
        List<String> current = Arrays.asList(this.file.list());
        Pair<List<String>, List<String>> intersection = CollectionUtil.intersection(this.fileList, current);
        this.fileList = current;
        if (!CollectionUtil.isEmpty((Collection)intersection.a)) {
            this.notifyChildrenListeners(FileMonitor.EventType.REMOVE_CHILDREN, (List)intersection.a);
        }
        if (!CollectionUtil.isEmpty((Collection)intersection.b)) {
            this.notifyChildrenListeners(FileMonitor.EventType.ADD_CHILDREN, (List)intersection.b);
        }
    }

    private synchronized void notifyChildrenListeners(FileMonitor.EventType type, List<String> a) {
        for (FileMonitor.EventListener li : this.list) {
            if (!(li instanceof ChildrenListener)) continue;
            ((ChildrenListener)li).childrenChange(type, a);
        }
    }

    private void checkDelete() {
        this.isDir = null;
        this.fileList = null;
    }

    public List<String> currentChildren() {
        return this.fileList == null ? null : Collections.unmodifiableList(this.fileList);
    }

    public Boolean isDir() {
        return this.isDir;
    }

    public static interface ChildrenListener
    extends FileMonitor.EventListener {
        public void childrenChange(FileMonitor.EventType var1, List<String> var2);
    }
}

