/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.event;

import org.apache.niolex.commons.event.Event;
import org.apache.niolex.commons.event.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(EventUtil.class);

    public static final void dispatch(Listener<?> l, Event<?> e) {
        EventUtil.castEvent(l, e);
    }

    private static final <V> void castEvent(Listener<V> l, Event<V> e) {
        try {
            l.eventHappened(e);
        }
        catch (ClassCastException ex) {
            EventUtil.onClassCastException(l, e, ex);
        }
    }

    public static final void onClassCastException(Listener<?> l, Event<?> e, ClassCastException ex) {
        LOG.warn("ClassCastException occured for event type [{}] class: {}; listener: {}.", new Object[]{e.getEventType(), e.getClass(), l, ex});
    }
}

