/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.util.SystemUtil;

public class PropertiesWrapper
extends Properties {
    private static final long serialVersionUID = -352075645997166876L;

    public static boolean parseBoolean(String s) {
        return StringUtil.isIn(s, false, "true", "1", "on", "yes");
    }

    public PropertiesWrapper() {
    }

    public PropertiesWrapper(Properties defaults) {
        super(defaults);
    }

    public PropertiesWrapper(String resource, Class<?> cls) throws IOException {
        this.load(resource, cls);
    }

    public PropertiesWrapper(String filePath) throws IOException {
        this.load(filePath);
    }

    public void load(String resource, Class<?> cls) throws IOException {
        this.load(cls.getResourceAsStream(resource));
    }

    public void load(String filePath) throws IOException {
        this.load(new FileInputStream(filePath));
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        try {
            super.load(inStream);
        }
        finally {
            SystemUtil.close(inStream);
        }
    }

    public final String getString(String key) {
        String s = this.getProperty(key);
        return s == null ? s : s.trim();
    }

    public final String getString(String key, String defaultValue) {
        String s = this.getProperty(key, defaultValue);
        return s == null ? s : s.trim();
    }

    public final int getInteger(String key) {
        return Integer.parseInt(this.getString(key));
    }

    public final int getInteger(String key, String defaultValue) {
        return Integer.parseInt(this.getString(key, defaultValue));
    }

    public final int getInteger(String key, int defaultValue) {
        String val = this.getString(key);
        return val == null ? defaultValue : Integer.parseInt(val);
    }

    public final long getLong(String key) {
        return Long.parseLong(this.getString(key));
    }

    public final long getLong(String key, String defaultValue) {
        return Long.parseLong(this.getString(key, defaultValue));
    }

    public final long getLong(String key, long defaultValue) {
        String val = this.getString(key);
        return val == null ? defaultValue : Long.parseLong(val);
    }

    public boolean getBoolean(String key) {
        String s = this.getString(key);
        return s == null ? false : PropertiesWrapper.parseBoolean(s);
    }

    public boolean getBoolean(String key, String defaultValue) {
        String s = this.getString(key, defaultValue);
        return s == null ? false : PropertiesWrapper.parseBoolean(s);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String s = this.getString(key);
        return s == null ? defaultValue : PropertiesWrapper.parseBoolean(s);
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.getString(key));
    }

    public double getDouble(String key, String defaultValue) {
        return Double.parseDouble(this.getString(key, defaultValue));
    }

    public double getDouble(String key, double defaultValue) {
        String val = this.getString(key);
        return val == null ? defaultValue : Double.parseDouble(val);
    }
}

