/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.config;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.niolex.commons.config.PropertiesWrapper;

public abstract class PropUtil {
    private static final PropertiesWrapper PROPS = new PropertiesWrapper();

    public static final void loadConfig(String resource, Class<?> cls) throws IOException {
        PROPS.load(cls.getResourceAsStream(resource));
    }

    public static final void loadConfig(String filePath) throws IOException {
        PROPS.load(new FileInputStream(filePath));
    }

    public static final String getProperty(String key) {
        return PROPS.getProperty(key);
    }

    public static final String getProperty(String key, String defaultValue) {
        return PROPS.getProperty(key, defaultValue);
    }

    public static final String getString(String key) {
        return PROPS.getString(key);
    }

    public static final String getString(String key, String defaultValue) {
        return PROPS.getString(key, defaultValue);
    }

    public static final int getInteger(String key) {
        return PROPS.getInteger(key);
    }

    public static final int getInteger(String key, String defaultValue) {
        return PROPS.getInteger(key, defaultValue);
    }

    public static final int getInteger(String key, int defaultValue) {
        return PROPS.getInteger(key, defaultValue);
    }

    public static final long getLong(String key) {
        return PROPS.getLong(key);
    }

    public static final long getLong(String key, String defaultValue) {
        return PROPS.getLong(key, defaultValue);
    }

    public static final long getLong(String key, long defaultValue) {
        return PROPS.getLong(key, defaultValue);
    }

    public static boolean getBoolean(String key) {
        return PROPS.getBoolean(key);
    }

    public static boolean getBoolean(String key, String defaultValue) {
        return PROPS.getBoolean(key, defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return PROPS.getBoolean(key, defaultValue);
    }

    public static double getDouble(String key) {
        return PROPS.getDouble(key);
    }

    public static double getDouble(String key, String defaultValue) {
        return PROPS.getDouble(key, defaultValue);
    }

    public static double getDouble(String key, double defaultValue) {
        return PROPS.getDouble(key, defaultValue);
    }
}

