/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import com.google.common.collect.Maps;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.niolex.commons.internal.Finally;

public class Syncer
implements InvocationHandler {
    public static final int BY_REGEX = 1;
    public static final int BY_ANNO = 2;
    public static final Integer LOCK_READ = 1;
    public static final Integer LOCK_WRITE = 2;
    public static final Integer NO_LOCK = 3;
    private final Map<Method, Integer> cache = Maps.newConcurrentMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final int matchBy;
    private final Object host;
    private final Pattern readPattern;
    private final Pattern writePattern;

    public static final <T> T syncByRegex(Object host, String readRegex, String writeRegex) {
        Syncer s = new Syncer(1, host, Pattern.compile(readRegex), Pattern.compile(writeRegex));
        Object ret = Proxy.newProxyInstance(host.getClass().getClassLoader(), host.getClass().getInterfaces(), (InvocationHandler)s);
        return (T)ret;
    }

    public static final <T> T syncByAnnotation(Object host) {
        Syncer s = new Syncer(2, host, null, null);
        Object ret = Proxy.newProxyInstance(host.getClass().getClassLoader(), host.getClass().getInterfaces(), (InvocationHandler)s);
        return (T)ret;
    }

    private Syncer(int matchBy, Object host, Pattern readPattern, Pattern writePattern) {
        this.matchBy = matchBy;
        this.host = host;
        this.readPattern = readPattern;
        this.writePattern = writePattern;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Integer i = this.cache.get(method);
        if (i != null) {
            if (i == LOCK_WRITE) {
                return Finally.useWriteLock(this.lock, this.host, method, args);
            }
            if (i == LOCK_READ) {
                return Finally.useReadLock(this.lock, this.host, method, args);
            }
            return method.invoke(this.host, args);
        }
        if (this.matchBy == 1) {
            String name = method.getName();
            if (this.writePattern.matcher(name).matches()) {
                this.cache.put(method, LOCK_WRITE);
                return Finally.useWriteLock(this.lock, this.host, method, args);
            }
            if (this.readPattern.matcher(name).matches()) {
                this.cache.put(method, LOCK_READ);
                return Finally.useReadLock(this.lock, this.host, method, args);
            }
            this.cache.put(method, NO_LOCK);
            return method.invoke(this.host, args);
        }
        if (method.isAnnotationPresent(Write.class)) {
            this.cache.put(method, LOCK_WRITE);
            return Finally.useWriteLock(this.lock, this.host, method, args);
        }
        if (method.isAnnotationPresent(Read.class)) {
            this.cache.put(method, LOCK_READ);
            return Finally.useReadLock(this.lock, this.host, method, args);
        }
        this.cache.put(method, NO_LOCK);
        return method.invoke(this.host, args);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Write {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Read {
    }
}

