/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.concurrent.ThreadFactory;

public class SimpleThreadFactory
implements ThreadFactory {
    private final ThreadGroup threadGroup;
    private final String threadGroupName;
    private final boolean isDaemon;
    private int cnt = 0;

    public SimpleThreadFactory(String threadGroupName) {
        this(threadGroupName, false);
    }

    public SimpleThreadFactory(String threadGroupName, boolean isDaemon) {
        this.threadGroup = new ThreadGroup(threadGroupName);
        this.threadGroupName = threadGroupName;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.threadGroup, r, this.threadGroupName + "-" + this.cnt++);
        t.setDaemon(this.isDaemon);
        return t;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }
}

