/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<V>
implements Future<V> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile V value;
    private volatile Throwable cause;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public void setDone(V v) {
        this.value = v;
        this.latch.countDown();
    }

    public void setAbort(Throwable cause) {
        this.cause = cause;
        this.latch.countDown();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.cause == null) {
            return this.value;
        }
        throw new ExecutionException(this.cause);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.cause == null) {
            return this.value;
        }
        throw new ExecutionException(this.cause);
    }
}

