/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.compress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class JacksonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static final ObjectMapper getmapper() {
        return mapper;
    }

    public static final JsonFactory getJsonFactory() {
        return mapper.getFactory();
    }

    public static final TypeFactory getTypeFactory() {
        return mapper.getTypeFactory();
    }

    public static final byte[] obj2bin(Object o) throws IOException {
        return mapper.writeValueAsBytes(o);
    }

    public static final <T> T bin2Obj(byte[] bin, Class<T> valueType) throws IOException {
        return (T)mapper.readValue(bin, valueType);
    }

    public static final <T> T bin2Obj(byte[] bin, JavaType valueType) throws IOException {
        return (T)mapper.readValue(bin, valueType);
    }

    public static final <T> T bin2Obj(byte[] bin, TypeReference<T> valueType) throws IOException {
        return (T)mapper.readValue(bin, valueType);
    }

    public static final String obj2Str(Object o) throws IOException {
        return mapper.writeValueAsString(o);
    }

    public static final <T> T str2Obj(String s, Class<T> valueType) throws IOException {
        return (T)mapper.readValue(s, valueType);
    }

    public static final <T> T str2Obj(String s, JavaType valueType) throws IOException {
        return (T)mapper.readValue(s, valueType);
    }

    public static final <T> T str2Obj(String s, TypeReference<T> valueType) throws IOException {
        return (T)mapper.readValue(s, valueType);
    }

    public static final void writeObj(OutputStream out, Object value) throws IOException {
        mapper.writeValue(out, value);
    }

    public static final <T> T readObj(InputStream in, Class<T> valueType) throws IOException {
        return (T)mapper.readValue(in, valueType);
    }

    public static final <T> T readObj(InputStream in, JavaType valueType) throws IOException {
        return (T)mapper.readValue(in, valueType);
    }

    public static final <T> T readObj(InputStream in, TypeReference<T> valueType) throws IOException {
        return (T)mapper.readValue(in, valueType);
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

