/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.compress;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.compress.Compressor;
import org.apache.niolex.commons.compress.JacksonUtil;

public abstract class AbstractCompressor
implements Compressor {
    @Override
    public byte[] compressString(String str) {
        return this.compress(str.getBytes(StringUtil.UTF_8));
    }

    @Override
    public String decompressString(byte[] data) {
        return new String(this.decompress(data), StringUtil.UTF_8);
    }

    @Override
    public byte[] compressObj(Object value) throws IOException {
        return this.compress(JacksonUtil.obj2bin(value));
    }

    @Override
    public <T> T decompressObj(byte[] data, Class<T> valueType) throws IOException {
        return JacksonUtil.bin2Obj(this.decompress(data), valueType);
    }

    @Override
    public <T> T decompressObj(byte[] data, JavaType valueType) throws IOException {
        return JacksonUtil.bin2Obj(this.decompress(data), valueType);
    }
}

