/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.collection;

import java.util.NoSuchElementException;

public class CyclicIntArray {
    private final int[] array;
    private int size;
    private int head;

    public CyclicIntArray(int size) {
        if (size < 2) {
            throw new IllegalArgumentException("The size must greater than 1.");
        }
        this.array = new int[size];
        this.size = 0;
        this.head = 0;
    }

    public int push(int k) {
        int r = this.array[this.head];
        this.array[this.head] = k;
        this.head = (this.head + 1) % this.array.length;
        if (this.size < this.array.length) {
            ++this.size;
        }
        return r;
    }

    public int pop() {
        if (this.size > 0) {
            --this.size;
            return this.array[(this.head + this.array.length - this.size - 1) % this.array.length];
        }
        throw new NoSuchElementException("The array is empty.");
    }

    public int[] getArray() {
        return this.array;
    }

    public int getHead() {
        return this.head;
    }

    public int size() {
        return this.size;
    }
}

