/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.niolex.commons.bean.Pair;

public abstract class CollectionUtil {
    @SafeVarargs
    public static final <E> List<E> concat(Collection<E> collection, E ... args) {
        ArrayList<E> dest = new ArrayList<E>(collection.size() + args.length);
        dest.addAll(collection);
        CollectionUtil.addAll(dest, args);
        return dest;
    }

    @SafeVarargs
    public static final <E> List<E> concat(E ... args) {
        ArrayList dest = new ArrayList(args.length);
        CollectionUtil.addAll(dest, args);
        return dest;
    }

    public static final <E> List<E> concat(Collection<E> collection1, Collection<E> collection2) {
        ArrayList<E> dest = new ArrayList<E>(collection1.size() + collection2.size());
        dest.addAll(collection1);
        dest.addAll(collection2);
        return dest;
    }

    public static final <E> List<E> concat(E[] array1, E[] array2) {
        ArrayList dest = new ArrayList(array1.length + array2.length);
        CollectionUtil.addAll(dest, array1);
        CollectionUtil.addAll(dest, array2);
        return dest;
    }

    public static final <E> List<E> concat(E element, Collection<E> args) {
        ArrayList<E> dest = new ArrayList<E>(1 + args.size());
        dest.add(element);
        dest.addAll(args);
        return dest;
    }

    @SafeVarargs
    public static final <E> void addAll(Collection<E> collection, E ... args) {
        for (int i = 0; i < args.length; ++i) {
            collection.add(args[i]);
        }
    }

    public static final <E> List<E> copy(Collection<E> args) {
        ArrayList<E> dest = new ArrayList<E>(args.size());
        dest.addAll(args);
        return dest;
    }

    public static final <E> Pair<List<E>, List<E>> intersection(Collection<E> left, Collection<E> right) {
        ArrayList<E> a = new ArrayList<E>(left);
        a.removeAll(right);
        ArrayList<E> b = new ArrayList<E>(right);
        b.removeAll(left);
        return new Pair<List<E>, List<E>>(a, b);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isSingle(Collection<?> collection) {
        return collection != null && collection.size() == 1;
    }

    public static boolean isSingle(Map<?, ?> map) {
        return map != null && map.size() == 1;
    }

    public static <K, V> V getOrInit(Map<K, V> map, K key, Class<V> cls) {
        V v = map.get(key);
        if (v == null) {
            try {
                v = cls.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The input class can not be initialized.", e);
            }
            map.put(key, v);
        }
        return v;
    }
}

