/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.collection;

import java.util.AbstractList;

public class CircularList<E>
extends AbstractList<E> {
    private final int capacity;
    private final Object[] elementData;
    private int head = 0;
    private int size = 0;

    public CircularList(int capacity) {
        if (capacity < 2) {
            throw new IllegalArgumentException("The capacity must greater than 1.");
        }
        this.capacity = capacity;
        this.elementData = new Object[capacity];
    }

    @Override
    public boolean add(E e) {
        if (this.size < this.capacity) {
            this.elementData[this.size++] = e;
        } else {
            this.elementData[this.head] = e;
            this.head = (this.head + 1) % this.capacity;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return (E)this.elementData[(this.head + index) % this.capacity];
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        index = (this.head + index) % this.capacity;
        Object e = this.elementData[index];
        this.elementData[index] = element;
        return (E)e;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public int size() {
        return this.size;
    }
}

