/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.coder;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.coder.BaseCoder;

public class RC2Coder
extends BaseCoder {
    private static final String ALGORITHM = "RC2";
    private static final String TRANSFORMATION = "RC2/CBC/ISO10126Padding";
    private Key secretKey;
    private AlgorithmParameterSpec ivParam;

    @Override
    public void initKey(String key) {
        byte[] keyData = Base64Util.base64ToByte(key);
        this.ivParam = new RC2ParameterSpec(128, keyData, 0);
        this.secretKey = new SecretKeySpec(keyData, keyData.length - 16, 16, ALGORITHM);
    }

    public void secureInitKey(String key) {
        byte[] keyData = Base64Util.base64ToByte(key);
        byte[] ivData = new byte[]{keyData[3], keyData[5], keyData[7], keyData[11], keyData[13], keyData[17], keyData[19], keyData[23]};
        this.ivParam = new RC2ParameterSpec(128, ivData, 0);
        byte[] realKey = new byte[16];
        int i = 0;
        int j = 1;
        while (i < 16) {
            realKey[i] = (byte)(keyData[i * 2] ^ keyData[j % keyData.length]);
            ++i;
            j += 3;
        }
        this.secretKey = new SecretKeySpec(realKey, ALGORITHM);
    }

    @Override
    public byte[] internalEncrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, this.secretKey, this.ivParam);
        return cipher.doFinal(data);
    }

    @Override
    public byte[] internalDecrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, this.secretKey, this.ivParam);
        return cipher.doFinal(data);
    }
}

