/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.coder;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.coder.BaseCoder;

public class DESCoder
extends BaseCoder {
    private static final String ALGORITHM = "DES";
    public static final String TRANSFORMATION = "DES/CBC/PKCS5Padding";
    private IvParameterSpec ivParam;
    private Key key;

    @Override
    public void initKey(String key) {
        byte[] keyData = Base64Util.base64ToByte(key);
        this.ivParam = new IvParameterSpec(keyData, 0, 8);
        this.initKey(keyData);
    }

    protected void initKey(byte[] keyData) {
        try {
            DESKeySpec dks = new DESKeySpec(keyData, keyData.length - 8);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            this.key = keyFactory.generateSecret(dks);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to init this key.", e);
        }
    }

    @Override
    public byte[] internalEncrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, this.key, this.ivParam);
        return cipher.doFinal(data);
    }

    @Override
    public byte[] internalDecrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, this.key, this.ivParam);
        return cipher.doFinal(data);
    }

    public String encodes(String ... args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            if (i >= args.length - 1) continue;
            sb.append(']').append(i).append('[');
        }
        sb.append("]");
        String encoded = this.encode(sb.toString());
        int i = encoded.indexOf(61);
        int l = encoded.length();
        i = i < 0 ? l : i;
        return encoded.substring(0, i) + '-' + (l - i);
    }

    public String decodes(String arg) {
        if (arg == null || arg.length() < 3) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(arg.substring(0, arg.length() - 2));
        int i = arg.charAt(arg.length() - 1) - 48;
        while (i-- > 0) {
            sb.append('=');
        }
        return this.decode(sb.toString());
    }
}

