/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.coder;

import java.nio.charset.Charset;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.coder.Coder;
import org.apache.niolex.commons.coder.CoderException;

public abstract class BaseCoder
implements Coder {
    public static final Charset ENC = StringUtil.UTF_8;

    protected abstract byte[] internalEncrypt(byte[] var1) throws Exception;

    protected abstract byte[] internalDecrypt(byte[] var1) throws Exception;

    @Override
    public byte[] encrypt(byte[] data) throws CoderException {
        try {
            return this.internalEncrypt(data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoderException("Failed to encrypt data.", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) throws CoderException {
        try {
            return this.internalDecrypt(data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoderException("Failed to decrypt data.", e);
        }
    }

    @Override
    public String decode(String str) throws CoderException {
        return new String(this.decrypt(Base64Util.base64ToByte(str)), ENC);
    }

    @Override
    public String encode(String str) throws CoderException {
        return Base64Util.byteToBase64(this.encrypt(str.getBytes(ENC)));
    }
}

