/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.codec.CipherUtil;
import org.apache.niolex.commons.codec.RSAHelper;

public abstract class RSAUtil
extends RSAHelper {
    public static String sign(byte[] data, String privateKey) {
        PrivateKey priKey = RSAUtil.getPrivateKey(privateKey);
        return RSAUtil.sign(data, priKey);
    }

    public static String sign(byte[] data, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            signature.update(data);
            return Base64Util.byteToBase64(signature.sign());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to sign the data.", e);
        }
    }

    public static boolean verify(byte[] data, String publicKey, String sign) {
        PublicKey pubKey = RSAUtil.getPublicKey(publicKey);
        return RSAUtil.verify(data, pubKey, sign);
    }

    public static boolean verify(byte[] data, PublicKey publicKey, String sign) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(Base64Util.base64ToByte(sign));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to verify the data.", e);
        }
    }

    public static byte[] decrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            return CipherUtil.process(cipher, 128, data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decrypt the data.", e);
        }
    }

    public static byte[] decryptByPrivateKey(byte[] data, String key) {
        PrivateKey privateKey = RSAUtil.getPrivateKey(key);
        return RSAUtil.decrypt(data, privateKey);
    }

    public static byte[] decryptByPublicKey(byte[] data, String key) {
        PublicKey publicKey = RSAUtil.getPublicKey(key);
        return RSAUtil.decrypt(data, publicKey);
    }

    public static byte[] encrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, key);
            return CipherUtil.process(cipher, 117, data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to encrypt the data.", e);
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data, String key) {
        PrivateKey privateKey = RSAUtil.getPrivateKey(key);
        return RSAUtil.encrypt(data, privateKey);
    }

    public static byte[] encryptByPublicKey(byte[] data, String key) {
        PublicKey publicKey = RSAUtil.getPublicKey(key);
        return RSAUtil.encrypt(data, publicKey);
    }
}

