/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.internal.IgnoreException;

public abstract class RSAHelper {
    public static final String ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static KeyPair initKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGen.initialize(1024);
        return keyPairGen.generateKeyPair();
    }

    public static KeyFactory getKeyFactory() {
        return IgnoreException.getKeyFactory(ALGORITHM);
    }

    public static PrivateKey getPrivateKey(String key) {
        byte[] keyBytes = Base64Util.base64ToByte(key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            return RSAHelper.getKeyFactory().generatePrivate(pkcs8KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key specification");
        }
    }

    public static PublicKey getPublicKey(String key) {
        byte[] keyBytes = Base64Util.base64ToByte(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        try {
            return RSAHelper.getKeyFactory().generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key specification");
        }
    }

    public static String encodeKeyToBase64(Key key) {
        return Base64Util.byteToBase64(key.getEncoded());
    }

    public static String encodePublicKeyToXml(PublicKey key) {
        if (!RSAPublicKey.class.isInstance(key)) {
            throw new IllegalArgumentException("The key you provided is not RSAPublicKey");
        }
        RSAPublicKey pubKey = (RSAPublicKey)key;
        StringBuilder sb = new StringBuilder();
        sb.append("<RSAKeyValue>");
        sb.append("<Modulus>").append(Base64Util.byteToBase64(pubKey.getModulus().toByteArray())).append("</Modulus>");
        sb.append("<Exponent>").append(Base64Util.byteToBase64(pubKey.getPublicExponent().toByteArray())).append("</Exponent>");
        sb.append("</RSAKeyValue>");
        return sb.toString();
    }

    public static String encodePrivateKeyToXml(PrivateKey key) {
        if (!RSAPrivateCrtKey.class.isInstance(key)) {
            throw new IllegalArgumentException("The key you provided is not RSAPrivateCrtKey");
        }
        RSAPrivateCrtKey priKey = (RSAPrivateCrtKey)key;
        StringBuilder sb = new StringBuilder();
        sb.append("<RSAKeyValue>");
        sb.append("<Modulus>").append(Base64Util.byteToBase64(priKey.getModulus().toByteArray())).append("</Modulus>");
        sb.append("<Exponent>").append(Base64Util.byteToBase64(priKey.getPublicExponent().toByteArray())).append("</Exponent>");
        sb.append("<P>").append(Base64Util.byteToBase64(priKey.getPrimeP().toByteArray())).append("</P>");
        sb.append("<Q>").append(Base64Util.byteToBase64(priKey.getPrimeQ().toByteArray())).append("</Q>");
        sb.append("<DP>").append(Base64Util.byteToBase64(priKey.getPrimeExponentP().toByteArray())).append("</DP>");
        sb.append("<DQ>").append(Base64Util.byteToBase64(priKey.getPrimeExponentQ().toByteArray())).append("</DQ>");
        sb.append("<InverseQ>").append(Base64Util.byteToBase64(priKey.getCrtCoefficient().toByteArray())).append("</InverseQ>");
        sb.append("<D>").append(Base64Util.byteToBase64(priKey.getPrivateExponent().toByteArray())).append("</D>");
        sb.append("</RSAKeyValue>");
        return sb.toString();
    }

    public static PublicKey decodePublicKeyFromXml(String xml) {
        xml = xml.replaceAll("[\r\n ]", "");
        BigInteger modulus = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<Modulus>", "</Modulus>")));
        BigInteger publicExponent = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<Exponent>", "</Exponent>")));
        RSAPublicKeySpec rsaPubKey = new RSAPublicKeySpec(modulus, publicExponent);
        try {
            return RSAHelper.getKeyFactory().generatePublic(rsaPubKey);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key specification");
        }
    }

    public static PrivateKey decodePrivateKeyFromXml(String xml) {
        xml = xml.replaceAll("\r", "").replaceAll("\n", "");
        BigInteger modulus = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<Modulus>", "</Modulus>")));
        BigInteger publicExponent = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<Exponent>", "</Exponent>")));
        BigInteger privateExponent = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<D>", "</D>")));
        BigInteger primeP = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<P>", "</P>")));
        BigInteger primeQ = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<Q>", "</Q>")));
        BigInteger primeExponentP = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<DP>", "</DP>")));
        BigInteger primeExponentQ = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<DQ>", "</DQ>")));
        BigInteger crtCoefficient = new BigInteger(1, Base64Util.base64ToByte(RSAHelper.getMiddleString(xml, "<InverseQ>", "</InverseQ>")));
        RSAPrivateCrtKeySpec rsaPriKey = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        try {
            return RSAHelper.getKeyFactory().generatePrivate(rsaPriKey);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key specification");
        }
    }

    public static String getMiddleString(String xml, String start, String end) {
        int s = xml.indexOf(start) + start.length();
        int e = xml.indexOf(end);
        return xml.substring(s, e);
    }
}

