/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import org.apache.niolex.commons.bean.Pair;
import org.apache.niolex.commons.codec.Base64Util;

public class KVBase64Util {
    public static String kvToBase64(byte[] key, byte[] value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("The parameter should not be null!");
        }
        int size = key.length + value.length;
        if (key.length > 63 || size > 512) {
            throw new IllegalArgumentException("The KV is too large!");
        }
        byte[] data = new byte[(size + 3) / 3 * 3];
        int start = data.length - size;
        int first = (key.length << 2) + start;
        data[0] = (byte)first;
        System.arraycopy(key, 0, data, start, key.length);
        System.arraycopy(value, 0, data, start + key.length, value.length);
        return Base64Util.byteToBase64URL(data);
    }

    public static Pair<byte[], byte[]> base64toKV(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The parameter should not be null!");
        }
        byte[] data = Base64Util.base64ToByte(str);
        int first = data[0] & 0xFF;
        int start = first & 3;
        byte[] key = new byte[first >>= 2];
        if ((first = data.length - first - start) < 0) {
            throw new IllegalArgumentException("The parameter is not KV encoded!");
        }
        byte[] value = new byte[first];
        System.arraycopy(data, start, key, 0, key.length);
        System.arraycopy(data, data.length - first, value, 0, value.length);
        return new Pair<byte[], byte[]>(key, value);
    }
}

