/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.commons.lang3.ArrayUtils;

public abstract class IntegerUtil {
    public static final long eightBytes(byte[] arr, int idx) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)(arr[idx + i] & 0xFF);
        }
        return l;
    }

    public static final byte[] toEightBytes(long l) {
        byte[] retVal = new byte[8];
        IntegerUtil.encEightBytes(l, retVal, 0);
        return retVal;
    }

    public static final void encEightBytes(long l, byte[] arr, int idx) {
        for (int i = 0; i < 8; ++i) {
            arr[i] = (byte)(l >> 8 * (7 - i));
        }
    }

    public static final int fourBytes(byte[] arr, int idx) {
        return IntegerUtil.fourBytes(arr[idx], arr[idx + 1], arr[idx + 2], arr[idx + 3]);
    }

    public static final int fourBytes(byte h, byte a, byte b, byte c) {
        return ((h & 0xFF) << 24) + ((a & 0xFF) << 16) + ((b & 0xFF) << 8) + (c & 0xFF);
    }

    public static final byte[] toFourBytes(int i) {
        byte[] arr = new byte[4];
        IntegerUtil.encFourBytes(i, arr, 0);
        return arr;
    }

    public static final void encFourBytes(int i, byte[] arr, int idx) {
        arr[idx++] = (byte)(i >> 24);
        arr[idx++] = (byte)(i >> 16);
        arr[idx++] = (byte)(i >> 8);
        arr[idx] = (byte)i;
    }

    public static final int threeBytes(byte a, byte b, byte c) {
        return ((a & 0xFF) << 16) + ((b & 0xFF) << 8) + (c & 0xFF);
    }

    public static final void encThreeBytes(int i, byte[] arr, int idx) {
        arr[idx++] = (byte)(i >> 16);
        arr[idx++] = (byte)(i >> 8);
        arr[idx] = (byte)i;
    }

    public static final int twoBytes(byte b, byte c) {
        return ((b & 0xFF) << 8) + (c & 0xFF);
    }

    public static final void encTwoBytes(int i, byte[] arr, int idx) {
        arr[idx++] = (byte)(i >> 8);
        arr[idx] = (byte)i;
    }

    public static final String formatSize(double size) {
        DecimalFormat df = new DecimalFormat("#,###.##");
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (size >= 1.099511627776E12) {
            return df.format(size / 1.099511627776E12) + "T";
        }
        if (size >= 1.073741824E9) {
            return df.format(size / 1.073741824E9) + "G";
        }
        if (size >= 1048576.0) {
            return df.format(size / 1048576.0) + "M";
        }
        if (size >= 1024.0) {
            return df.format(size / 1024.0) + "K";
        }
        return df.format(size);
    }

    public static final double fromSize(String str) {
        int len = str.length();
        str = str.toUpperCase();
        double size = 0.0;
        switch (str.charAt(len - 1)) {
            case 'T': {
                size = 1.099511627776E12;
                break;
            }
            case 'G': {
                size = 1.073741824E9;
                break;
            }
            case 'M': {
                size = 1048576.0;
                break;
            }
            case 'K': {
                size = 1024.0;
                break;
            }
            default: {
                size = 1.0;
            }
        }
        if (size != 1.0) {
            str = str.substring(0, len - 1);
        }
        return size * Double.parseDouble(str);
    }

    public static final boolean isIn(int target, int ... args) {
        if (ArrayUtils.isEmpty((int[])args)) {
            return false;
        }
        for (int i : args) {
            if (target != i) continue;
            return true;
        }
        return false;
    }
}

