/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.codec;

import java.util.Arrays;
import org.apache.niolex.commons.codec.IntegerUtil;

public class CommonBase64 {
    public static final String STD_BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int[] DEC_TBL = new int[128];
    private static final char[] ENC_STD = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] ENC_URL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int CODE_INVALID = -1;
    private static final int CODE_PADDING = -2;
    private static final char CHAR_PADDING = '=';
    private static final byte BYTE_PADDING = 0;

    public static void encTrunk(char[] table, StringBuilder out, byte a, byte b, byte c) {
        int i = IntegerUtil.threeBytes(a, b, c);
        out.append(table[i >> 18]);
        out.append(table[i >> 12 & 0x3F]);
        out.append(table[i >> 6 & 0x3F]);
        out.append(table[i & 0x3F]);
    }

    public static void encTail(char[] table, StringBuilder out, byte a, byte b, boolean padding, int len) {
        int i = IntegerUtil.threeBytes(a, b, (byte)0);
        out.append(table[i >> 18]);
        out.append(table[i >> 12 & 0x3F]);
        if (len == 1) {
            if (padding) {
                out.append('=');
                out.append('=');
            }
            return;
        }
        out.append(table[i >> 6 & 0x3F]);
        if (len == 2) {
            if (padding) {
                out.append('=');
            }
            return;
        }
    }

    public static final String encode(byte[] bytes) {
        return CommonBase64.encode(bytes, true, -1, false);
    }

    public static final String encodeURL(byte[] bytes) {
        return CommonBase64.encode(bytes, false, -1, true);
    }

    public static final String encode(byte[] bytes, boolean needPadding, int lineLength, boolean isURL) {
        int i;
        char[] table = isURL ? ENC_URL : ENC_STD;
        StringBuilder sb = new StringBuilder();
        if (lineLength != -1 && (lineLength < 64 || lineLength > 76 || lineLength % 4 != 0)) {
            throw new IllegalArgumentException("Invalid line length: " + lineLength);
        }
        int len = bytes.length;
        int cnt = 0;
        for (i = 0; i < len - 2; i += 3) {
            CommonBase64.encTrunk(table, sb, bytes[i], bytes[i + 1], bytes[i + 2]);
            if (lineLength == -1 || (cnt += 4) % lineLength != 0 || i == len - 3) continue;
            sb.append('\r');
            sb.append('\n');
        }
        if (i != len) {
            if (len - i == 1) {
                CommonBase64.encTail(table, sb, bytes[i], (byte)0, needPadding, 1);
            } else if (len - i == 2) {
                CommonBase64.encTail(table, sb, bytes[i], bytes[i + 1], needPadding, 2);
            }
        }
        return sb.toString();
    }

    public static boolean isBase64(String in) {
        try {
            CommonBase64.tidyBase64String(in);
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static char[] tidyBase64String(String in) {
        int len;
        int mod;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            int code;
            char c = in.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c > '\u007f' || (code = DEC_TBL[c]) == -1) {
                throw new IllegalArgumentException("The input string is not a valid Base64 string, invalid char is [" + c + "] at " + i);
            }
            if (code == -2) break;
            sb.append(c);
        }
        if ((mod = (len = sb.length()) % 4) == 1) {
            throw new IllegalArgumentException("The input string is not a valid Base64 string, Incomplete block.");
        }
        char[] dst = new char[len];
        sb.getChars(0, len, dst, 0);
        return dst;
    }

    public static void decTrunk(byte[] out, int odx, char[] in, int idx) {
        int i;
        int k = 0;
        for (i = idx; i < idx + 4; ++i) {
            k = (k << 6) + DEC_TBL[in[i]];
        }
        i = odx;
        int j = 16;
        while (i < odx + 3) {
            out[i] = (byte)(k >> j & 0xFF);
            ++i;
            j -= 8;
        }
    }

    public static void decTail(byte[] out, int odx, char[] in, int idx, int len) {
        int k = 0;
        int i = idx;
        int j = 0;
        while (i < idx + 4) {
            k = (k << 6) + (j < len ? DEC_TBL[in[i]] : 0);
            ++i;
            ++j;
        }
        i = odx;
        j = 16;
        while (i < odx + len - 1) {
            out[i] = (byte)(k >> j & 0xFF);
            ++i;
            j -= 8;
        }
    }

    public static byte[] decode(String input) {
        char[] in = CommonBase64.tidyBase64String(input);
        int len = in.length;
        int mod = len % 4;
        int outLen = len / 4 * 3 + (mod > 0 ? mod - 1 : 0);
        byte[] out = new byte[outLen];
        int i = 0;
        int j = 0;
        while (i < len - 3) {
            CommonBase64.decTrunk(out, j, in, i);
            i += 4;
            j += 3;
        }
        if (i != len) {
            CommonBase64.decTail(out, j, in, i, mod);
        }
        return out;
    }

    static {
        CommonBase64.ENC_URL[62] = 45;
        CommonBase64.ENC_URL[63] = 95;
        Arrays.fill(DEC_TBL, -1);
        for (int i = 0; i < 64; ++i) {
            CommonBase64.DEC_TBL[CommonBase64.ENC_STD[i]] = i;
        }
        CommonBase64.DEC_TBL[45] = 62;
        CommonBase64.DEC_TBL[46] = 62;
        CommonBase64.DEC_TBL[95] = 63;
        CommonBase64.DEC_TBL[44] = 63;
        CommonBase64.DEC_TBL[61] = -2;
    }
}

