/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql.jsonb;

import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.jsonb.JsonbSupport;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JsonbExpressionBuilder {
    private static final ArgConverter DATE_TIME_CONVERTER = new ArgConverter(){

        @Override
        public boolean accepts(String s) {
            return ISO_DATE_TIME_PATTERN.matcher(s).matches() || ISO_DATE_PATTERN.matcher(s).matches() || ISO_TIME_PATTERN.matcher(s).matches();
        }

        @Override
        public ArgValue convert(String s) {
            return new ArgValue(s, BaseJsonType.DATE_TIME);
        }
    };
    private static final ArgConverter DATE_TIME_CONVERTER_TZ = new ArgConverter(){

        @Override
        public boolean accepts(String s) {
            return ISO_DATE_TIME_PATTERN_TZ.matcher(s).matches() || ISO_TIME_PATTERN_TZ.matcher(s).matches();
        }

        @Override
        public ArgValue convert(String s) {
            return new ArgValue(s, BaseJsonType.DATE_TIME_TZ);
        }
    };
    private static final ArgConverter NUMBER_CONVERTER = new ArgConverter(){

        @Override
        public boolean accepts(String s) {
            return NUMBER_PATTERN.matcher(s).matches() || INTEGER_PATTERN.matcher(s).matches();
        }

        @Override
        public ArgValue convert(String s) {
            return new ArgValue(s, BaseJsonType.NUMBER);
        }
    };
    private static final ArgConverter BOOLEAN_ARG_CONVERTER = new ArgConverter(){

        @Override
        public boolean accepts(String s) {
            return BOOLEAN_PATTERN.matcher(s).matches();
        }

        @Override
        public ArgValue convert(String s) {
            return new ArgValue(s, BaseJsonType.BOOLEAN);
        }
    };
    private static final Pattern ISO_DATE_TIME_PATTERN_TZ = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[+-]\\d{2}:\\d{2})$");
    private static final Pattern ISO_TIME_PATTERN_TZ = Pattern.compile("^\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[+-]\\d{2}:\\d{2})$");
    private static final Pattern ISO_DATE_TIME_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?$");
    private static final Pattern ISO_DATE_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private static final Pattern ISO_TIME_PATTERN = Pattern.compile("^\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?$");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("^(true|false)$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+\\.\\d+$");
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern WILD_CARD_PATTERN = Pattern.compile("\\*");
    private static final Set<ComparisonOperator> FORBIDDEN_NEGATION = Set.of(RSQLOperators.NOT_EQUAL, RSQLOperators.IS_NULL, RSQLOperators.NOT_IN, RSQLOperators.NOT_LIKE, RSQLOperators.IGNORE_CASE_NOT_LIKE, RSQLOperators.NOT_BETWEEN);
    private static final Set<ComparisonOperator> NOT_RELEVANT_FOR_CONVERSION = Set.of(RSQLOperators.NOT_NULL, RSQLOperators.LIKE, RSQLOperators.IGNORE_CASE);
    private static final Set<ComparisonOperator> REQUIRE_NO_ARGUMENTS = Set.of(RSQLOperators.NOT_NULL);
    private static final Set<ComparisonOperator> REQUIRE_ONE_ARGUMENT = Set.of(RSQLOperators.EQUAL, RSQLOperators.GREATER_THAN, RSQLOperators.GREATER_THAN_OR_EQUAL, RSQLOperators.LESS_THAN, RSQLOperators.LESS_THAN_OR_EQUAL, RSQLOperators.LIKE, RSQLOperators.IGNORE_CASE, RSQLOperators.IGNORE_CASE_LIKE);
    private static final Set<ComparisonOperator> REQUIRE_TWO_ARGUMENTS = Set.of(RSQLOperators.BETWEEN);
    private static final Set<ComparisonOperator> REQUIRE_AT_LEAST_ONE_ARGUMENT = Set.of(RSQLOperators.IN);
    private static final Map<ComparisonOperator, String> COMPARISON_TEMPLATE = Map.ofEntries(Map.entry(RSQLOperators.NOT_NULL, "(%s != null)"), Map.entry(RSQLOperators.EQUAL, "(%s == %s)"), Map.entry(RSQLOperators.GREATER_THAN, "(%s > %s)"), Map.entry(RSQLOperators.GREATER_THAN_OR_EQUAL, "(%s >= %s)"), Map.entry(RSQLOperators.LESS_THAN, "(%s < %s)"), Map.entry(RSQLOperators.LESS_THAN_OR_EQUAL, "(%s <= %s)"), Map.entry(RSQLOperators.LIKE, "(%s like_regex %s)"), Map.entry(RSQLOperators.IGNORE_CASE, "(%s like_regex %s flag \"i\")"), Map.entry(RSQLOperators.IGNORE_CASE_LIKE, "(%s like_regex %s flag \"i\")"), Map.entry(RSQLOperators.BETWEEN, "(%1$s >= %2$s && %1$s <= %3$s)"));
    private static final String JSONB_PATH_EXISTS = "jsonb_path_exists";
    private static final String JSONB_PATH_EXISTS_TZ = "jsonb_path_exists_tz";
    private final ComparisonOperator operator;
    private final String keyPath;
    private final List<ArgValue> values;

    JsonbExpressionBuilder(ComparisonOperator operator, String keyPath, List<String> args) {
        this.operator = Objects.requireNonNull(operator);
        this.keyPath = Objects.requireNonNull(keyPath);
        if (FORBIDDEN_NEGATION.contains(operator)) {
            throw new IllegalArgumentException("Operator " + operator + " cannot be negated");
        }
        List<String> candidateValues = this.removeEmptyValuesIfNullCheck(operator, args);
        if (candidateValues.isEmpty() && !REQUIRE_NO_ARGUMENTS.contains(operator)) {
            throw new IllegalArgumentException("Values must not be empty");
        }
        if (REQUIRE_TWO_ARGUMENTS.contains(operator) && candidateValues.size() != 2) {
            throw new IllegalArgumentException("Operator " + operator + " requires two values");
        }
        if (REQUIRE_ONE_ARGUMENT.contains(operator) && candidateValues.size() != 1) {
            throw new IllegalArgumentException("Operator " + operator + " requires one value");
        }
        if (REQUIRE_AT_LEAST_ONE_ARGUMENT.contains(operator) && candidateValues.isEmpty()) {
            throw new IllegalArgumentException("Operator " + operator + " requires at least one value");
        }
        this.values = this.findMoreTypes(operator, candidateValues);
    }

    public JsonbSupport.JsonbPathExpression getJsonPathExpression() {
        List<String> valuesToCompare = this.values.stream().map(argValue -> argValue.print(this.operator)).toList();
        String targetPath = String.format("$.%s", this.removeJsonbReferenceFromKeyPath(this.keyPath));
        boolean isDataTime = this.values.stream().anyMatch(argValue -> argValue.baseJsonType().equals((Object)BaseJsonType.DATE_TIME));
        boolean isDateTimeTz = this.values.stream().anyMatch(argValue -> argValue.baseJsonType().equals((Object)BaseJsonType.DATE_TIME_TZ));
        String valueReference = this.values.stream().filter(v -> isDataTime || isDateTimeTz).findFirst().map(v -> "@.datetime()").orElse("@");
        ComparisonOperator realOperator = this.transformEqualsToLike(this.operator, valuesToCompare);
        String comparisonTemplate = this.operatorToTemplate(realOperator, valuesToCompare.size());
        ArrayList<String> templateArguments = new ArrayList<String>();
        templateArguments.add(valueReference);
        templateArguments.addAll(valuesToCompare);
        String function = isDateTimeTz ? JSONB_PATH_EXISTS_TZ : JSONB_PATH_EXISTS;
        String expression = String.format("%s ? %s", targetPath, String.format(comparisonTemplate, templateArguments.toArray()));
        return new JsonbSupport.JsonbPathExpression(function, expression);
    }

    private List<String> removeEmptyValuesIfNullCheck(ComparisonOperator operator, List<String> args) {
        if (operator.equals((Object)RSQLOperators.NOT_NULL)) {
            return Collections.emptyList();
        }
        return args;
    }

    private List<ArgValue> findMoreTypes(ComparisonOperator operator, List<String> values) {
        if (NOT_RELEVANT_FOR_CONVERSION.contains(operator)) {
            return values.stream().map(s -> new ArgValue((String)s, BaseJsonType.STRING)).toList();
        }
        List<ArgConverter> argConverters = JsonbSupport.DATE_TIME_SUPPORT ? List.of(DATE_TIME_CONVERTER, DATE_TIME_CONVERTER_TZ, NUMBER_CONVERTER, BOOLEAN_ARG_CONVERTER) : List.of(NUMBER_CONVERTER, BOOLEAN_ARG_CONVERTER);
        Optional<ArgConverter> candidateConverter = argConverters.stream().filter(argConverter -> values.stream().allMatch(argConverter::accepts)).findFirst();
        return candidateConverter.map(argConverter -> values.stream().map(argConverter::convert).toList()).orElseGet(() -> values.stream().map(s -> new ArgValue((String)s, BaseJsonType.STRING)).toList());
    }

    private ComparisonOperator transformEqualsToLike(ComparisonOperator operator, List<String> valuesToCompare) {
        boolean hasWildcard = valuesToCompare.stream().anyMatch(s -> s.contains("*"));
        if (!hasWildcard) {
            return operator;
        }
        if (operator.equals((Object)RSQLOperators.EQUAL)) {
            return RSQLOperators.LIKE;
        }
        return operator;
    }

    String removeJsonbReferenceFromKeyPath(String keyPath) {
        List<String> keyPathParts = Arrays.asList(keyPath.split("\\."));
        if (keyPathParts.isEmpty()) {
            return "";
        }
        keyPathParts = keyPathParts.subList(1, keyPathParts.size());
        return String.join((CharSequence)".", keyPathParts);
    }

    String operatorToTemplate(ComparisonOperator operator, int numberOfArguments) {
        if (operator.equals((Object)RSQLOperators.IN)) {
            if (numberOfArguments < 1) {
                throw new IllegalArgumentException("In operator requires at least one value");
            }
            ArrayList<CallSite> orChain = new ArrayList<CallSite>();
            for (int i = 1; i <= numberOfArguments; ++i) {
                orChain.add((CallSite)((Object)("%1$s == %" + (i + 1) + "$s")));
            }
            return orChain.stream().collect(Collectors.joining(" || ", "(", ")"));
        }
        return Optional.ofNullable(COMPARISON_TEMPLATE.get(operator)).orElseThrow(() -> new UnsupportedOperationException(operator + " is not supported yet"));
    }

    static interface ArgConverter {
        public boolean accepts(String var1);

        public ArgValue convert(String var1);
    }

    record ArgValue(String value, BaseJsonType baseJsonType) {
        String print(ComparisonOperator operator) {
            return switch (this.baseJsonType) {
                default -> throw new IncompatibleClassChangeError();
                case BaseJsonType.STRING -> String.format("\"%s\"", this.printString(operator));
                case BaseJsonType.NUMBER, BaseJsonType.BOOLEAN -> this.value;
                case BaseJsonType.NULL -> "null";
                case BaseJsonType.DATE_TIME, BaseJsonType.DATE_TIME_TZ -> String.format("\"%s\".datetime()", this.value);
            };
        }

        String printString(ComparisonOperator operator) {
            String value = this.value;
            if ((operator.equals((Object)RSQLOperators.LIKE) || operator.equals((Object)RSQLOperators.NOT_LIKE) || operator.equals((Object)RSQLOperators.IGNORE_CASE_LIKE) || operator.equals((Object)RSQLOperators.IGNORE_CASE_NOT_LIKE)) && !value.contains("*")) {
                return String.format(".*%s.*", value);
            }
            return value.replaceAll(WILD_CARD_PATTERN.pattern(), ".*");
        }
    }

    private static enum BaseJsonType {
        STRING,
        NUMBER,
        BOOLEAN,
        NULL,
        DATE_TIME,
        DATE_TIME_TZ;

    }
}

