/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import io.github.perplexhub.rsql.FunctionBlackListedException;
import io.github.perplexhub.rsql.FunctionNotWhiteListedException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface Selector {
    public static final Pattern LONG_PATTERN = Pattern.compile("-?\\d+");
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    public Expression<?> getExpression(BiFunction<String, CriteriaBuilder, Expression<?>> var1);

    public static Selector selectorOf(String column, CriteriaBuilder criteriaBuilder) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null");
        }
        if (column.isBlank()) {
            throw new IllegalArgumentException("Column cannot be blank");
        }
        if (column.startsWith("@")) {
            int argStart = column.indexOf(91);
            int argEnd = column.lastIndexOf(93);
            if (argStart > 0 && argEnd > 0 && argEnd > argStart) {
                String function = column.substring(1, argStart);
                String argsString = column.substring(argStart + 1, argEnd);
                List<Selector> args = Stream.of(argsString.split("\\|")).map(String::trim).map(arg -> Selector.selectorOf(arg, criteriaBuilder)).toList();
                return new FunctionSelector(function, args, criteriaBuilder);
            }
        } else if (column.startsWith("#")) {
            String value = column.substring(1);
            if (Objects.equals(value, "null")) {
                return new ValueSelector(null, criteriaBuilder);
            }
            Object object = Selector.numberFromString(value).orElseGet(() -> Selector.booleanFromString(value).orElse(value));
            return new ValueSelector(object, criteriaBuilder);
        }
        return new SingleColumnSelector(column, criteriaBuilder);
    }

    public static Optional<Object> nullFromString(String value) {
        if (value.equalsIgnoreCase("null")) {
            return Optional.of(new NullValue());
        }
        return Optional.empty();
    }

    public static Optional<Object> booleanFromString(String value) {
        if (value.equalsIgnoreCase("true")) {
            return Optional.of(Boolean.TRUE);
        }
        if (value.equalsIgnoreCase("false")) {
            return Optional.of(Boolean.FALSE);
        }
        return Optional.empty();
    }

    public static Optional<Object> numberFromString(String value) {
        Matcher matcher = LONG_PATTERN.matcher(value);
        if (matcher.matches()) {
            return Optional.of(Long.parseLong(value));
        }
        matcher = DOUBLE_PATTERN.matcher(value);
        if (matcher.matches()) {
            return Optional.of(Double.parseDouble(value));
        }
        return Optional.empty();
    }

    public static void assertWhiteListed(Selector selector, Collection<String> whiteList) {
        if (selector instanceof FunctionSelector) {
            FunctionSelector functionSelector = (FunctionSelector)selector;
            if (whiteList == null || !Selector.matchesInCollection(functionSelector.function, whiteList)) {
                throw new FunctionNotWhiteListedException(functionSelector.function);
            }
            functionSelector.arguments.forEach(argument -> Selector.assertWhiteListed(argument, whiteList));
        }
    }

    public static void assertNotBlackListed(Selector selector, Collection<String> blackList) {
        if (blackList == null || blackList.isEmpty()) {
            return;
        }
        if (selector instanceof FunctionSelector) {
            FunctionSelector functionSelector = (FunctionSelector)selector;
            if (Selector.matchesInCollection(functionSelector.function, blackList)) {
                throw new FunctionBlackListedException(functionSelector.function);
            }
            functionSelector.arguments.forEach(argument -> Selector.assertNotBlackListed(argument, blackList));
        }
    }

    public static boolean matchesInCollection(String value, Collection<String> values) {
        return values.stream().anyMatch(value::matches);
    }

    public record FunctionSelector(String function, Collection<Selector> arguments, CriteriaBuilder builder) implements Selector
    {
        @Override
        public Expression<?> getExpression(BiFunction<String, CriteriaBuilder, Expression<?>> columnMapper) {
            Expression[] expressions = (Expression[])this.arguments.stream().map(argument -> argument.getExpression(columnMapper)).toArray(Expression[]::new);
            return this.builder.function(this.function, Object.class, expressions);
        }
    }

    public record ValueSelector(Object value, CriteriaBuilder builder) implements Selector
    {
        @Override
        public Expression<?> getExpression(BiFunction<String, CriteriaBuilder, Expression<?>> columnMapper) {
            if (this.value == null) {
                return this.builder.nullLiteral(Object.class);
            }
            Object object = this.value;
            if (object instanceof String) {
                String stringValue = (String)object;
                stringValue = stringValue.replace("\t", " ");
                return this.builder.literal((Object)stringValue);
            }
            if (this.value instanceof NullValue) {
                return this.builder.nullLiteral(Object.class);
            }
            return this.builder.literal(this.value);
        }
    }

    public record SingleColumnSelector(String column, CriteriaBuilder criteriaBuilder) implements Selector
    {
        @Override
        public Expression<?> getExpression(BiFunction<String, CriteriaBuilder, Expression<?>> columnMapper) {
            return columnMapper.apply(this.column, this.criteriaBuilder);
        }
    }

    public record NullValue() {
    }
}

