/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql.jsonb;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.jsonb.JsonbExpressionBuilder;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Map;
import java.util.Optional;

public class JsonbSupport {
    public static boolean DATE_TIME_SUPPORT = false;
    private static final Map<ComparisonOperator, ComparisonOperator> NEGATE_OPERATORS = Map.of(RSQLOperators.NOT_EQUAL, RSQLOperators.EQUAL, RSQLOperators.NOT_IN, RSQLOperators.IN, RSQLOperators.IS_NULL, RSQLOperators.NOT_NULL, RSQLOperators.NOT_LIKE, RSQLOperators.LIKE, RSQLOperators.IGNORE_CASE_NOT_LIKE, RSQLOperators.IGNORE_CASE_LIKE, RSQLOperators.NOT_BETWEEN, RSQLOperators.BETWEEN);

    public static Predicate jsonbPathExists(CriteriaBuilder builder, ComparisonNode node, Path<?> attrPath) {
        Optional<ComparisonOperator> mayBeInvertedOperator = Optional.ofNullable(NEGATE_OPERATORS.get(node.getOperator()));
        JsonbExpressionBuilder jsb = new JsonbExpressionBuilder(mayBeInvertedOperator.orElse(node.getOperator()), node.getSelector(), node.getArguments());
        JsonbPathExpression expression = jsb.getJsonPathExpression();
        Expression function = builder.function(expression.jsonbFunction, Boolean.class, new Expression[]{attrPath, builder.literal((Object)expression.jsonbPath)});
        if (mayBeInvertedOperator.isPresent()) {
            return builder.isFalse(function);
        }
        return builder.isTrue(function);
    }

    record JsonbPathExpression(String jsonbFunction, String jsonbPath) {
    }
}

