/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import io.github.perplexhub.rsql.RSQLJPAContext;
import io.github.perplexhub.rsql.RSQLJPAPredicateConverter;
import io.github.perplexhub.rsql.SortSupport;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class SortUtils {
    private static final Pattern MULTIPLE_SORT_SEPARATOR = Pattern.compile(";");
    private static final Pattern SORT_SEPARATOR = Pattern.compile(",");

    private SortUtils() {
    }

    static List<Order> parseSort(@Nullable String sort, Map<String, String> propertyMapper, Root<?> root, CriteriaBuilder cb) {
        SortSupport sortSupport = SortSupport.builder().sortQuery(sort).propertyPathMapper(propertyMapper).build();
        return SortUtils.parseSort(sortSupport, root, cb);
    }

    static List<Order> parseSort(SortSupport sortSupport, Root<?> root, CriteriaBuilder cb) {
        if (!StringUtils.hasText((String)sortSupport.getSortQuery())) {
            return new ArrayList<Order>();
        }
        return MULTIPLE_SORT_SEPARATOR.splitAsStream(sortSupport.getSortQuery()).map(SortUtils::split).filter(parts -> ((String[])parts).length > 0).map(parts -> SortUtils.sortToJpaOrder(parts, sortSupport, root, cb)).collect(Collectors.toList());
    }

    private static String[] split(String sort) {
        return (String[])SORT_SEPARATOR.splitAsStream(sort).filter(StringUtils::hasText).toArray(String[]::new);
    }

    private static Order sortToJpaOrder(String[] parts, SortSupport sortSupport, Root<?> root, CriteriaBuilder cb) {
        Expression propertyExpression;
        String property = parts[0];
        String direction = parts.length > 1 ? parts[1] : "asc";
        RSQLJPAPredicateConverter rsqljpaPredicateConverter = new RSQLJPAPredicateConverter(cb, sortSupport.getPropertyPathMapper(), null, sortSupport.getJoinHints());
        RSQLJPAContext rsqljpaContext = rsqljpaPredicateConverter.findPropertyPath(property, (Path)root);
        boolean isJson = rsqljpaPredicateConverter.isJsonType(rsqljpaContext.getAttribute());
        Object object = propertyExpression = isJson ? SortUtils.jsonPathOf(rsqljpaContext.getPath(), property, cb) : rsqljpaContext.getPath();
        if (parts.length > 2 && "ic".equalsIgnoreCase(parts[2]) && String.class.isAssignableFrom(propertyExpression.getJavaType())) {
            propertyExpression = cb.lower(propertyExpression);
        }
        return direction.equalsIgnoreCase("asc") ? cb.asc(propertyExpression) : cb.desc(propertyExpression);
    }

    private static Expression<?> jsonPathOf(Path<?> path, String property, CriteriaBuilder builder) {
        ArrayList args = new ArrayList();
        args.add(path);
        Stream.of(property.split("\\.")).skip(1L).map(arg_0 -> ((CriteriaBuilder)builder).literal(arg_0)).forEach(args::add);
        return builder.function("jsonb_extract_path", String.class, (Expression[])args.toArray(Expression[]::new));
    }
}

