/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.JoinUtils;
import io.github.perplexhub.rsql.RSQLCustomPredicate;
import io.github.perplexhub.rsql.RSQLCustomPredicateInput;
import io.github.perplexhub.rsql.RSQLException;
import io.github.perplexhub.rsql.RSQLJPAContext;
import io.github.perplexhub.rsql.RSQLJPASupport;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import io.github.perplexhub.rsql.UnknownPropertyException;
import io.github.perplexhub.rsql.jsonb.JsonbSupport;
import jakarta.persistence.Column;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.vendor.Database;

public class RSQLJPAPredicateConverter
extends RSQLVisitorBase<Predicate, From> {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPAPredicateConverter.class);
    private static final Set<Database> JSON_SUPPORT = EnumSet.of(Database.POSTGRESQL);
    private final CriteriaBuilder builder;
    private final Map<String, Path> cachedJoins = new HashMap<String, Path>();
    private final Map<String, String> propertyPathMapper;
    private final Map<ComparisonOperator, RSQLCustomPredicate<?>> customPredicates;
    private final Map<String, JoinType> joinHints;
    private final boolean strictEquality;
    private final Character likeEscapeCharacter;

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper) {
        this(builder, propertyPathMapper, null, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates) {
        this(builder, propertyPathMapper, customPredicates, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints) {
        this(builder, propertyPathMapper, customPredicates, joinHints, false, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints, boolean strictEquality, Character likeEscapeCharacter) {
        this.builder = builder;
        this.propertyPathMapper = propertyPathMapper != null ? propertyPathMapper : Collections.emptyMap();
        this.customPredicates = customPredicates != null ? customPredicates.stream().collect(Collectors.toMap(RSQLCustomPredicate::getOperator, Function.identity(), (a, b) -> a)) : Collections.emptyMap();
        this.joinHints = joinHints != null ? joinHints : Collections.emptyMap();
        this.strictEquality = strictEquality;
        this.likeEscapeCharacter = likeEscapeCharacter;
    }

    RSQLJPAContext findPropertyPath(String propertyPath, Path startRoot) {
        Class type = startRoot.getJavaType();
        ManagedType classMetadata = this.getManagedType(type);
        ManagedType previousClassMetadata = null;
        Path<?> root = startRoot;
        Attribute attribute = null;
        String[] properties = this.mapPropertyPath(propertyPath).split("\\.");
        int propertiesLength = properties.length;
        for (int i = 0; i < propertiesLength; ++i) {
            String property = properties[i];
            String mappedProperty = this.mapProperty(property, classMetadata.getJavaType());
            if (!mappedProperty.equals(property)) {
                RSQLJPAContext context = this.findPropertyPath(mappedProperty, (Path)root);
                root = context.getPath();
                attribute = context.getAttribute();
                continue;
            }
            if (!this.hasPropertyName(mappedProperty, classMetadata)) {
                throw new UnknownPropertyException(mappedProperty, classMetadata.getJavaType());
            }
            if (this.isAssociationType(mappedProperty, classMetadata) && !property.equals(propertyPath)) {
                Class associationType;
                boolean isOneToAssociationType = this.isOneToOneAssociationType(mappedProperty, classMetadata) || this.isOneToManyAssociationType(mappedProperty, classMetadata);
                type = associationType = this.findPropertyType(mappedProperty, classMetadata);
                String previousClass = classMetadata.getJavaType().getName();
                previousClassMetadata = classMetadata;
                classMetadata = this.getManagedType(associationType);
                String keyJoin = this.getKeyJoin(root, mappedProperty);
                if (isOneToAssociationType) {
                    if (this.joinHints.containsKey(keyJoin)) {
                        log.debug("Create a join between [{}] and [{}] using key [{}] with supplied hints", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                        root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                        continue;
                    }
                    log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                    root = this.join(keyJoin, root, mappedProperty, JoinType.LEFT);
                    continue;
                }
                String lookAheadProperty = i < propertiesLength - 1 ? properties[i + 1] : null;
                boolean lookAheadPropertyIsId = false;
                if (!this.isManyToManyAssociationType(mappedProperty, previousClassMetadata) && classMetadata instanceof IdentifiableType && lookAheadProperty != null) {
                    IdentifiableType identifiableType = (IdentifiableType)classMetadata;
                    SingularAttribute id = identifiableType.getId(identifiableType.getIdType().getJavaType());
                    if (identifiableType.hasSingleIdAttribute() && id.isId() && id.getName().equals(lookAheadProperty)) {
                        lookAheadPropertyIsId = true;
                    }
                }
                if (lookAheadPropertyIsId || lookAheadProperty == null) {
                    log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
                    root = root.get(mappedProperty);
                    continue;
                }
                log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                continue;
            }
            if (this.isElementCollectionType(mappedProperty, classMetadata)) {
                String previousClass = classMetadata.getJavaType().getName();
                attribute = classMetadata.getAttribute(property);
                classMetadata = this.getManagedElementCollectionType(mappedProperty, classMetadata);
                String keyJoin = this.getKeyJoin(root, mappedProperty);
                log.debug("Create a element collection join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty);
                continue;
            }
            if (this.isJsonType(mappedProperty, classMetadata)) {
                root = root.get(mappedProperty);
                attribute = classMetadata.getAttribute(mappedProperty);
                break;
            }
            log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
            root = root.get(mappedProperty);
            if (this.isEmbeddedType(mappedProperty, classMetadata)) {
                Class embeddedType;
                type = embeddedType = this.findPropertyType(mappedProperty, classMetadata);
                classMetadata = this.getManagedType(embeddedType);
                continue;
            }
            attribute = classMetadata.getAttribute(property);
        }
        if (attribute != null) {
            this.accessControl(type, attribute.getName());
        }
        return RSQLJPAContext.of(root, attribute);
    }

    private boolean isJsonType(String mappedProperty, ManagedType<?> classMetadata) {
        return Optional.ofNullable(classMetadata.getAttribute(mappedProperty)).map(this::isJsonType).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isJsonType(Attribute<?, ?> attribute) {
        if (!this.isJsonColumn(attribute)) return false;
        if (this.getDatabase(attribute).map(JSON_SUPPORT::contains).orElse(false) == false) return false;
        return true;
    }

    private boolean isJsonColumn(Attribute<?, ?> attribute) {
        return Optional.ofNullable(attribute).filter(attr -> attr.getJavaMember() instanceof Field).map(attr -> (Field)attr.getJavaMember()).map(field -> field.getAnnotation(Column.class)).map(Column::columnDefinition).map("jsonb"::equalsIgnoreCase).orElse(false);
    }

    private Optional<Database> getDatabase(Attribute<?, ?> attribute) {
        return this.getEntityManagerMap().values().stream().filter(em -> em.getMetamodel().getManagedTypes().contains(attribute.getDeclaringType())).findFirst().map(em -> (Database)RSQLJPAPredicateConverter.getEntityManagerDatabase().get(em));
    }

    private String getKeyJoin(Path<?> root, String mappedProperty) {
        return root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty) {
        return this.join(keyJoin, root, mappedProperty, null);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty, JoinType joinType) {
        log.debug("join(keyJoin:{},root:{},mappedProperty:{},joinType:{})", new Object[]{keyJoin, root, mappedProperty, joinType});
        if (this.cachedJoins.containsKey(keyJoin)) {
            root = this.cachedJoins.get(keyJoin);
        } else {
            root = JoinUtils.getOrCreateJoin((From)root, mappedProperty, joinType);
            this.cachedJoins.put(keyJoin, (Path)root);
        }
        return root;
    }

    public Predicate visit(ComparisonNode node, From root) {
        Class type;
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        ComparisonOperator op = node.getOperator();
        RSQLJPAContext holder = this.findPropertyPath(node.getSelector(), (Path)root);
        Path<?> attrPath = holder.getPath();
        Attribute<?, ?> attribute = holder.getAttribute();
        if (this.customPredicates.containsKey(op)) {
            RSQLCustomPredicate<?> customPredicate = this.customPredicates.get(op);
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                arguments.add(this.convert(argument, customPredicate.getType()));
            }
            return (Predicate)customPredicate.getConverter().apply(RSQLCustomPredicateInput.of((CriteriaBuilder)this.builder, attrPath, attribute, arguments, (From)root));
        }
        if (this.isJsonType(attribute)) {
            return JsonbSupport.jsonbPathExists(this.builder, node, attrPath);
        }
        Class clazz = type = attribute != null ? attribute.getJavaType() : null;
        if (attribute != null) {
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                type = this.getElementCollectionGenericType(type, attribute);
            }
            if (type.isPrimitive()) {
                type = (Class)primitiveToWrapper.get(type);
            } else if (RSQLJPASupport.getValueTypeMap().containsKey(type)) {
                type = (Class)RSQLJPASupport.getValueTypeMap().get(type);
            }
        }
        if (node.getArguments().size() > 1) {
            ArrayList<Object> listObject = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                listObject.add(this.convert(argument, type));
            }
            if (op.equals((Object)RSQLOperators.IN)) {
                return attrPath.in(listObject);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return attrPath.in(listObject).not();
            }
            if (op.equals((Object)RSQLOperators.BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                return this.builder.between(attrPath, (Comparable)listObject.get(0), (Comparable)listObject.get(1));
            }
            if (op.equals((Object)RSQLOperators.NOT_BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                return this.builder.between(attrPath, (Comparable)listObject.get(0), (Comparable)listObject.get(1)).not();
            }
        } else {
            if (op.equals((Object)RSQLOperators.IS_NULL)) {
                return this.builder.isNull(attrPath);
            }
            if (op.equals((Object)RSQLOperators.NOT_NULL)) {
                return this.builder.isNotNull(attrPath);
            }
            Object argument = this.convert((String)node.getArguments().get(0), type);
            if (op.equals((Object)RSQLOperators.IN)) {
                return this.builder.equal(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return this.builder.notEqual(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.LIKE)) {
                return this.likePredicate((Expression)attrPath, "%" + argument.toString() + "%", this.builder);
            }
            if (op.equals((Object)RSQLOperators.NOT_LIKE)) {
                return this.likePredicate((Expression)attrPath, "%" + argument.toString() + "%", this.builder).not();
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE)) {
                return this.builder.equal(this.builder.upper(attrPath), (Object)argument.toString().toUpperCase());
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_LIKE)) {
                return this.likePredicate(this.builder.upper(attrPath), "%" + argument.toString().toUpperCase() + "%", this.builder);
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_NOT_LIKE)) {
                return this.likePredicate(this.builder.upper(attrPath), "%" + argument.toString().toUpperCase() + "%", this.builder).not();
            }
            if (op.equals((Object)RSQLOperators.EQUAL)) {
                return this.equalPredicate((Expression)attrPath, type, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL)) {
                return this.equalPredicate((Expression)attrPath, type, argument).not();
            }
            if (!Comparable.class.isAssignableFrom(type)) {
                log.error("Operator {} can be used only for Comparables", (Object)op);
                throw new RSQLException(String.format("Operator %s can be used only for Comparables", op));
            }
            Comparable comparable = (Comparable)argument;
            if (op.equals((Object)RSQLOperators.GREATER_THAN)) {
                return this.builder.greaterThan(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.GREATER_THAN_OR_EQUAL)) {
                return this.builder.greaterThanOrEqualTo(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN)) {
                return this.builder.lessThan(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN_OR_EQUAL)) {
                return this.builder.lessThanOrEqualTo(attrPath, comparable);
            }
        }
        log.error("Unknown operator: {}", (Object)op);
        throw new RSQLException("Unknown operator: " + op);
    }

    private Predicate likePredicate(Expression attributePath, String likeExpression, CriteriaBuilder builder) {
        return Optional.ofNullable(this.likeEscapeCharacter).map(character -> builder.like(attributePath, likeExpression, character.charValue())).orElseGet(() -> builder.like(attributePath, likeExpression));
    }

    private Predicate equalPredicate(Expression expr, Class type, Object argument) {
        if (type.equals(String.class)) {
            String argStr = argument.toString();
            if (this.strictEquality) {
                return this.builder.equal(expr, argument);
            }
            if (argStr.contains("*") && argStr.contains("^")) {
                return this.likePredicate(this.builder.upper(expr), argStr.replace('*', '%').replace("^", "").toUpperCase(), this.builder);
            }
            if (argStr.contains("*")) {
                return this.likePredicate(expr, argStr.replace('*', '%'), this.builder);
            }
            if (argStr.contains("^")) {
                return this.builder.equal(this.builder.upper(expr), (Object)argStr.replace("^", "").toUpperCase());
            }
            return this.builder.equal(expr, argument);
        }
        if (argument == null) {
            return this.builder.isNull(expr);
        }
        return this.builder.equal(expr, argument);
    }

    public Predicate visit(AndNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return (Predicate)node.getChildren().stream().map(n -> (Predicate)n.accept((RSQLVisitor)this, (Object)root)).collect(Collectors.reducing((arg_0, arg_1) -> ((CriteriaBuilder)this.builder).and(arg_0, arg_1))).get();
    }

    public Predicate visit(OrNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return (Predicate)node.getChildren().stream().map(n -> (Predicate)n.accept((RSQLVisitor)this, (Object)root)).collect(Collectors.reducing((arg_0, arg_1) -> ((CriteriaBuilder)this.builder).or(arg_0, arg_1))).get();
    }

    public Map<String, String> getPropertyPathMapper() {
        return this.propertyPathMapper;
    }

    public Map<ComparisonOperator, RSQLCustomPredicate<?>> getCustomPredicates() {
        return this.customPredicates;
    }

    public Map<String, JoinType> getJoinHints() {
        return this.joinHints;
    }
}

