/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;

final class JoinUtils {
    private JoinUtils() {
    }

    public static <X, Z> Join<X, ?> getOrCreateJoin(From<Z, X> root, String attribute, JoinType joinType) {
        Join<X, ?> join = JoinUtils.getJoin(root, attribute, joinType);
        return join == null ? JoinUtils.createJoin(root, attribute, joinType) : join;
    }

    private static <X, Z> Join<X, ?> createJoin(From<Z, X> root, String attribute, JoinType joinType) {
        return joinType == null ? root.join(attribute) : root.join(attribute, joinType);
    }

    private static <X, Z> Join<X, ?> getJoin(From<Z, X> root, String attribute, JoinType joinType) {
        Join<X, ?> fetchJoin = JoinUtils.getJoinFromFetches(root, attribute, joinType);
        if (fetchJoin != null) {
            return fetchJoin;
        }
        return JoinUtils.getJoinFromJoins(root, attribute, joinType);
    }

    private static <X, Z> Join<X, ?> getJoinFromFetches(From<Z, X> root, String attribute, JoinType joinType) {
        for (Fetch fetch : root.getFetches()) {
            if (!Join.class.isAssignableFrom(fetch.getClass()) || !fetch.getAttribute().getName().equals(attribute) || joinType != null && !fetch.getJoinType().equals((Object)joinType)) continue;
            return (Join)fetch;
        }
        return null;
    }

    private static <X, Z> Join<X, ?> getJoinFromJoins(From<Z, X> root, String attribute, JoinType joinType) {
        for (Join join : root.getJoins()) {
            if (!join.getAttribute().getName().equals(attribute) || joinType != null && !join.getJoinType().equals((Object)joinType)) continue;
            return join;
        }
        return null;
    }
}

