/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import io.github.perplexhub.rsql.RSQLJPAContext;
import io.github.perplexhub.rsql.RSQLJPAPredicateConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class SortUtils {
    private static final Pattern MULTIPLE_SORT_SEPARATOR = Pattern.compile(";");
    private static final Pattern SORT_SEPARATOR = Pattern.compile(",");

    SortUtils() {
    }

    static List<Order> parseSort(@Nullable String sort, Map<String, String> propertyMapper, Root<?> root, CriteriaBuilder cb) {
        if (sort == null) {
            return new ArrayList<Order>();
        }
        return MULTIPLE_SORT_SEPARATOR.splitAsStream(sort).map(SortUtils::split).filter(parts -> ((String[])parts).length > 0).map(parts -> SortUtils.sortToJpaOrder(parts, propertyMapper, root, cb)).collect(Collectors.toList());
    }

    private static String[] split(String sort) {
        return (String[])SORT_SEPARATOR.splitAsStream(sort).filter(StringUtils::hasText).toArray(String[]::new);
    }

    private static Order sortToJpaOrder(String[] parts, Map<String, String> propertyMapper, Root<?> root, CriteriaBuilder cb) {
        String property = parts[0];
        String direction = parts.length > 1 ? parts[1] : "asc";
        RSQLJPAPredicateConverter rsqljpaPredicateConverter = new RSQLJPAPredicateConverter(cb, propertyMapper);
        RSQLJPAContext rsqljpaContext = rsqljpaPredicateConverter.findPropertyPath(property, (Path)root);
        Expression propertyExpression = rsqljpaContext.getPath();
        if (parts.length > 2 && "ic".equalsIgnoreCase(parts[2]) && String.class.isAssignableFrom(propertyExpression.getJavaType())) {
            propertyExpression = cb.lower(propertyExpression);
        }
        return direction.equalsIgnoreCase("asc") ? cb.asc(propertyExpression) : cb.desc(propertyExpression);
    }
}

