/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.RSQLCustomPredicate;
import io.github.perplexhub.rsql.RSQLCustomPredicateInput;
import io.github.perplexhub.rsql.RSQLException;
import io.github.perplexhub.rsql.RSQLJPAContext;
import io.github.perplexhub.rsql.RSQLJPASupport;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import io.github.perplexhub.rsql.UnknownPropertyException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSQLJPAPredicateConverter
extends RSQLVisitorBase<Predicate, From> {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPAPredicateConverter.class);
    private final CriteriaBuilder builder;
    private final Map<String, Path> cachedJoins = new HashMap<String, Path>();
    private final Map<String, String> propertyPathMapper;
    private final Map<ComparisonOperator, RSQLCustomPredicate<?>> customPredicates;
    private final Map<String, JoinType> joinHints;
    private final boolean strictEquality;

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper) {
        this(builder, propertyPathMapper, null, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates) {
        this(builder, propertyPathMapper, customPredicates, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints) {
        this(builder, propertyPathMapper, customPredicates, null, false);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints, boolean strictEquality) {
        this.builder = builder;
        this.propertyPathMapper = propertyPathMapper != null ? propertyPathMapper : Collections.emptyMap();
        this.customPredicates = customPredicates != null ? customPredicates.stream().collect(Collectors.toMap(RSQLCustomPredicate::getOperator, Function.identity(), (a, b) -> a)) : Collections.emptyMap();
        this.joinHints = joinHints != null ? joinHints : Collections.emptyMap();
        this.strictEquality = strictEquality;
    }

    RSQLJPAContext findPropertyPath(String propertyPath, Path startRoot) {
        Class type = startRoot.getJavaType();
        ManagedType classMetadata = this.getManagedType(type);
        ManagedType previousClassMetadata = null;
        Path<?> root = startRoot;
        Attribute attribute = null;
        String[] properties = this.mapPropertyPath(propertyPath).split("\\.");
        int propertiesLength = properties.length;
        for (int i = 0; i < propertiesLength; ++i) {
            String property = properties[i];
            String mappedProperty = this.mapProperty(property, classMetadata.getJavaType());
            if (!mappedProperty.equals(property)) {
                RSQLJPAContext context = this.findPropertyPath(mappedProperty, (Path)root);
                root = context.getPath();
                attribute = context.getAttribute();
                continue;
            }
            if (!this.hasPropertyName(mappedProperty, classMetadata)) {
                if (Modifier.isAbstract(classMetadata.getJavaType().getModifiers())) {
                    Optional<Class> foundSubClass = new Reflections(classMetadata.getJavaType().getPackage().getName(), new Scanner[0]).getSubTypesOf(classMetadata.getJavaType()).stream().filter(subType -> this.hasPropertyName(mappedProperty, this.getManagedType((Class)subType))).findFirst();
                    if (foundSubClass.isPresent()) {
                        classMetadata = this.getManagedType(foundSubClass.get());
                        root = root instanceof Join ? this.builder.treat((Join)root, foundSubClass.get()).get(property) : this.builder.treat((Path)root, foundSubClass.get()).get(property);
                        attribute = classMetadata.getAttribute(property);
                        continue;
                    }
                    throw new UnknownPropertyException(mappedProperty, classMetadata.getJavaType());
                }
                throw new UnknownPropertyException(mappedProperty, classMetadata.getJavaType());
            }
            if (this.isAssociationType(mappedProperty, classMetadata) && !property.equals(propertyPath)) {
                Class associationType;
                boolean isOneToAssociationType = this.isOneToOneAssociationType(mappedProperty, classMetadata) || this.isOneToManyAssociationType(mappedProperty, classMetadata);
                type = associationType = this.findPropertyType(mappedProperty, classMetadata);
                String previousClass = classMetadata.getJavaType().getName();
                previousClassMetadata = classMetadata;
                classMetadata = this.getManagedType(associationType);
                String keyJoin = root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
                if (isOneToAssociationType) {
                    if (this.joinHints.containsKey(keyJoin)) {
                        log.debug("Create a join between [{}] and [{}] using key [{}] with supplied hints", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                        root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                        continue;
                    }
                    log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                    root = this.join(keyJoin, root, mappedProperty, JoinType.LEFT);
                    continue;
                }
                String lookAheadProperty = i < propertiesLength - 1 ? properties[i + 1] : null;
                boolean lookAheadPropertyIsId = false;
                if (!this.isManyToManyAssociationType(mappedProperty, previousClassMetadata) && classMetadata instanceof IdentifiableType && lookAheadProperty != null) {
                    IdentifiableType identifiableType = (IdentifiableType)classMetadata;
                    SingularAttribute id = identifiableType.getId(identifiableType.getIdType().getJavaType());
                    if (identifiableType.hasSingleIdAttribute() && id.isId() && id.getName().equals(lookAheadProperty)) {
                        lookAheadPropertyIsId = true;
                    }
                }
                if (lookAheadPropertyIsId || lookAheadProperty == null) {
                    log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
                    root = root.get(mappedProperty);
                    continue;
                }
                log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                continue;
            }
            if (this.isElementCollectionType(mappedProperty, classMetadata)) {
                String previousClass = classMetadata.getJavaType().getName();
                attribute = classMetadata.getAttribute(property);
                classMetadata = this.getManagedElementCollectionType(mappedProperty, classMetadata);
                String keyJoin = root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
                log.debug("Create a element collection join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty);
                continue;
            }
            log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
            root = root.get(mappedProperty);
            if (this.isEmbeddedType(mappedProperty, classMetadata)) {
                Class embeddedType;
                type = embeddedType = this.findPropertyType(mappedProperty, classMetadata);
                classMetadata = this.getManagedType(embeddedType);
                continue;
            }
            attribute = classMetadata.getAttribute(property);
        }
        if (attribute != null) {
            this.accessControl(type, attribute.getName());
        }
        return RSQLJPAContext.of(root, attribute);
    }

    private String getKeyJoin(Path<?> root, String mappedProperty) {
        return root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty) {
        return this.join(keyJoin, root, mappedProperty, null);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty, JoinType joinType) {
        log.debug("join(keyJoin:{},root:{},mappedProperty:{},joinType:{})", new Object[]{keyJoin, root, mappedProperty, joinType});
        if (this.cachedJoins.containsKey(keyJoin)) {
            root = this.cachedJoins.get(keyJoin);
        } else {
            root = joinType == null ? ((From)root).join(mappedProperty) : ((From)root).join(mappedProperty, joinType);
            this.cachedJoins.put(keyJoin, root);
        }
        return root;
    }

    public Predicate visit(ComparisonNode node, From root) {
        Class type;
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        ComparisonOperator op = node.getOperator();
        RSQLJPAContext holder = this.findPropertyPath(node.getSelector(), (Path)root);
        Path<?> attrPath = holder.getPath();
        Attribute<?, ?> attribute = holder.getAttribute();
        if (this.customPredicates.containsKey(op)) {
            RSQLCustomPredicate<?> customPredicate = this.customPredicates.get(op);
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                arguments.add(this.convert(argument, customPredicate.getType()));
            }
            return (Predicate)customPredicate.getConverter().apply(RSQLCustomPredicateInput.of((CriteriaBuilder)this.builder, attrPath, attribute, arguments, (From)root));
        }
        Class clazz = type = attribute != null ? attribute.getJavaType() : null;
        if (attribute != null) {
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                type = this.getElementCollectionGenericType(type, attribute);
            }
            if (type.isPrimitive()) {
                type = (Class)primitiveToWrapper.get(type);
            } else if (RSQLJPASupport.getValueTypeMap().containsKey(type)) {
                type = (Class)RSQLJPASupport.getValueTypeMap().get(type);
            }
        }
        if (node.getArguments().size() > 1) {
            ArrayList<Object> listObject = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                listObject.add(this.convert(argument, type));
            }
            if (op.equals((Object)RSQLOperators.IN)) {
                return attrPath.in(listObject);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return attrPath.in(listObject).not();
            }
            if (op.equals((Object)RSQLOperators.BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                return this.builder.between(attrPath, (Comparable)listObject.get(0), (Comparable)listObject.get(1));
            }
            if (op.equals((Object)RSQLOperators.NOT_BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                return this.builder.between(attrPath, (Comparable)listObject.get(0), (Comparable)listObject.get(1)).not();
            }
        } else {
            if (op.equals((Object)RSQLOperators.IS_NULL)) {
                return this.builder.isNull(attrPath);
            }
            if (op.equals((Object)RSQLOperators.NOT_NULL)) {
                return this.builder.isNotNull(attrPath);
            }
            Object argument = this.convert((String)node.getArguments().get(0), type);
            if (op.equals((Object)RSQLOperators.IN)) {
                return this.builder.equal(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return this.builder.notEqual(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.LIKE)) {
                return this.builder.like(attrPath, "%" + argument.toString() + "%");
            }
            if (op.equals((Object)RSQLOperators.NOT_LIKE)) {
                return this.builder.like(attrPath, "%" + argument.toString() + "%").not();
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE)) {
                return this.builder.equal(this.builder.upper(attrPath), (Object)argument.toString().toUpperCase());
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_LIKE)) {
                return this.builder.like(this.builder.upper(attrPath), "%" + argument.toString().toUpperCase() + "%");
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_NOT_LIKE)) {
                return this.builder.like(this.builder.upper(attrPath), "%" + argument.toString().toUpperCase() + "%").not();
            }
            if (op.equals((Object)RSQLOperators.EQUAL)) {
                return this.equalPredicate(attrPath, type, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL)) {
                return this.equalPredicate(attrPath, type, argument).not();
            }
            if (!Comparable.class.isAssignableFrom(type)) {
                log.error("Operator {} can be used only for Comparables", (Object)op);
                throw new RSQLException(String.format("Operator %s can be used only for Comparables", op));
            }
            Comparable comparable = (Comparable)argument;
            if (op.equals((Object)RSQLOperators.GREATER_THAN)) {
                return this.builder.greaterThan(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.GREATER_THAN_OR_EQUAL)) {
                return this.builder.greaterThanOrEqualTo(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN)) {
                return this.builder.lessThan(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN_OR_EQUAL)) {
                return this.builder.lessThanOrEqualTo(attrPath, comparable);
            }
        }
        log.error("Unknown operator: {}", (Object)op);
        throw new RSQLException("Unknown operator: " + op);
    }

    private Predicate equalPredicate(Path attrPath, Class type, Object argument) {
        if (type.equals(String.class)) {
            String argStr = argument.toString();
            if (this.strictEquality) {
                return this.builder.equal((Expression)attrPath, argument);
            }
            if (argStr.contains("*") && argStr.contains("^")) {
                return this.builder.like(this.builder.upper((Expression)attrPath), argStr.replace('*', '%').replace("^", "").toUpperCase());
            }
            if (argStr.contains("*")) {
                return this.builder.like((Expression)attrPath, argStr.replace('*', '%'));
            }
            if (argStr.contains("^")) {
                return this.builder.equal(this.builder.upper((Expression)attrPath), (Object)argStr.replace("^", "").toUpperCase());
            }
            return this.builder.equal((Expression)attrPath, argument);
        }
        if (argument == null) {
            return this.builder.isNull((Expression)attrPath);
        }
        return this.builder.equal((Expression)attrPath, argument);
    }

    public Predicate visit(AndNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return (Predicate)node.getChildren().stream().map(n -> (Predicate)n.accept((RSQLVisitor)this, (Object)root)).collect(Collectors.reducing((arg_0, arg_1) -> ((CriteriaBuilder)this.builder).and(arg_0, arg_1))).get();
    }

    public Predicate visit(OrNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return (Predicate)node.getChildren().stream().map(n -> (Predicate)n.accept((RSQLVisitor)this, (Object)root)).collect(Collectors.reducing((arg_0, arg_1) -> ((CriteriaBuilder)this.builder).or(arg_0, arg_1))).get();
    }

    public Map<String, String> getPropertyPathMapper() {
        return this.propertyPathMapper;
    }

    public Map<ComparisonOperator, RSQLCustomPredicate<?>> getCustomPredicates() {
        return this.customPredicates;
    }

    public Map<String, JoinType> getJoinHints() {
        return this.joinHints;
    }
}

