/*
 * Decompiled with CFR 0.152.
 */
package setup;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bH'J\b\u0010\u0013\u001a\u00020\u0010H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lsetup/PackageManagerSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "nodeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getNodeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "packageManager", "Lorg/gradle/api/provider/Property;", "LPackageManager;", "getPackageManager", "()Lorg/gradle/api/provider/Property;", "packageManagerWithVersion", "", "getPackageManagerWithVersion", "fixPackageManagerLink", "", "getNodeService", "LNodeService;", "run", "Companion", "GradleNpmPlugin"})
public abstract class PackageManagerSetupTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "packageManagerSetup";

    public PackageManagerSetupTask() {
        this.setDescription("Install the package manager defined in the package.json file or explicitly in the build.gradle.kts file.");
    }

    @Internal
    @NotNull
    public abstract Property<NodeService> getNodeService();

    @Input
    @NotNull
    public abstract Property<PackageManager> getPackageManager();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPackageManagerWithVersion();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getNodeDir();

    @TaskAction
    public final void run() {
        String string = this.getPackageManagerWithVersion().isPresent() ? (String)this.getPackageManagerWithVersion().get() : ((PackageManager)((Object)this.getPackageManager().get())).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (packageManagerWithVe\u2026eManager.get().toString()");
        String packageManager = string;
        String[] stringArray = new String[]{"install", "-g", packageManager};
        Process process = ((NodeService)this.getNodeService().get()).executeCommand((Task)this, PackageManager.NPM, stringArray);
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new RuntimeException("Package manager '" + packageManager + "' installation failed with exit value " + process.exitValue());
        }
        this.getLogger().info("Package manager '" + packageManager + "' was successfully installed");
        this.fixPackageManagerLink(PackageManager.Companion.fromString(packageManager).toString());
    }

    private final void fixPackageManagerLink(String packageManager) {
        if (!Os.isFamily((String)"windows")) {
            Path binPath = ((Directory)this.getNodeDir().dir("bin").get()).getAsFile().toPath();
            Path scriptPath = binPath.resolve(packageManager);
            Files.deleteIfExists(scriptPath);
            Path targetPath = ((Directory)this.getNodeDir().dir("lib/node_modules/corepack/dist/" + packageManager + ".js").get()).getAsFile().toPath();
            Path fixedScriptPath = binPath.relativize(targetPath);
            Files.createSymbolicLink(scriptPath, fixedScriptPath, new FileAttribute[0]);
            this.getLogger().debug("Fixed broken symlink: {} with target {}", (Object)this.getName(), (Object)fixedScriptPath);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsetup/PackageManagerSetupTask$Companion;", "", "()V", "NAME", "", "GradleNpmPlugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

