/*
 * Decompiled with CFR 0.152.
 */
package io.github.pepperkit.githooks;

import io.github.pepperkit.githooks.GitHooksManager;
import io.github.pepperkit.githooks.GitHooksPluginExtension;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleScriptException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logging;
import org.slf4j.Logger;

public class GitHooksPlugin
implements Plugin<Project> {
    private final org.gradle.api.logging.Logger logger = Logging.getLogger(GitHooksPlugin.class);
    GitHooksManager gitHooksManager = new GitHooksManager((Logger)this.logger);

    public void apply(Project project) {
        GitHooksPluginExtension extension = (GitHooksPluginExtension)project.getExtensions().create("gitHooksGradlePlugin", GitHooksPluginExtension.class, new Object[0]);
        Task initGitHooks = (Task)project.getTasks().register("initGitHooks").get();
        initGitHooks.doLast(task -> this.initGitHooks((Task)task, (Map)extension.getHooks().get()));
    }

    protected void initGitHooks(Task task, Map<String, String> hooks) {
        this.logger.info("Git Hooks Plugin is launched");
        this.logger.debug("Hooks: {}", hooks);
        List<File> existingHookFiles = this.gitHooksManager.getExistingHookFiles();
        if (hooks == null || hooks.isEmpty()) {
            existingHookFiles.forEach(File::delete);
            return;
        }
        this.gitHooksManager.checkProvidedHookNamesCorrectness(hooks);
        this.gitHooksManager.checkGitHooksDirAndCreateIfMissing();
        String hookToBeCreated = null;
        try {
            for (Map.Entry<String, String> hook : hooks.entrySet()) {
                hookToBeCreated = hook.getKey();
                this.gitHooksManager.createHook(hookToBeCreated, hook.getValue());
            }
            this.logger.info("Git Hooks are successfully initialized");
        }
        catch (IOException e) {
            throw new GradleScriptException("Cannot write hook `" + hookToBeCreated + "`", (Throwable)e);
        }
    }
}

