/*
 * Decompiled with CFR 0.152.
 */
package io.github.pepperkit.githooks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class GitHooksManager {
    private static final Path GIT_PATH = Paths.get(".git", new String[0]);
    private static final Path GIT_HOOKS_PATH = Paths.get(".git", "hooks");
    private static final String SHEBANG = "#!/bin/sh";
    static final Set<String> GIT_HOOKS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("applypatch-msg", "commit-msg", "fsmonitor-watchman", "post-update", "pre-applypatch", "pre-commit", "pre-merge-commit", "pre-push", "pre-rebase", "pre-receive", "prepare-commit-msg", "push-to-checkout", "update")));
    private static final Set<PosixFilePermission> HOOK_FILE_PERMISSIONS = Collections.unmodifiableSet(new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)));
    private final Logger logger;

    public GitHooksManager(Logger logger) {
        this.logger = logger;
    }

    void checkProvidedHookNamesCorrectness(Map<String, String> hooks) {
        for (Map.Entry<String, String> entry : hooks.entrySet()) {
            if (GIT_HOOKS.contains(entry.getKey())) continue;
            throw new IllegalStateException("`" + entry.getKey() + "` is not a git hook. Available hooks are: " + GIT_HOOKS);
        }
    }

    void checkGitHooksDirAndCreateIfMissing() {
        if (!Files.exists(GIT_PATH, new LinkOption[0])) {
            throw new IllegalStateException("It seems that it's not a git repository. Plugin goals should be executed from the root of the project.");
        }
        if (!Files.exists(GIT_HOOKS_PATH, new LinkOption[0])) {
            try {
                Files.createDirectories(GIT_HOOKS_PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create directory " + GIT_HOOKS_PATH, e);
            }
        }
    }

    List<File> getExistingHookFiles() {
        return GIT_HOOKS.stream().map(this::getHookPath).filter(h -> Files.exists(Paths.get(h, new String[0]), new LinkOption[0])).map(File::new).collect(Collectors.toList());
    }

    void createHook(String hookName, String hookValue) throws IOException {
        String hookPath = this.getHookPath(hookName);
        String fullHookValue = "#!/bin/sh\n" + hookValue.replaceAll("[ ]{2,}", "");
        Optional<String> existingHookValue = this.readHook(hookName);
        if (existingHookValue.isPresent() && existingHookValue.get().equals(fullHookValue)) {
            this.logger.info("The hook `" + hookName + "` has not changed, skipping");
        } else {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(hookPath));){
                Set<PosixFilePermission> currentPermissions;
                this.logger.info("Writing `" + hookName + "` hook");
                writer.write(fullHookValue);
                Path hookFilePath = Paths.get(hookPath, new String[0]);
                if (hookFilePath.getFileSystem().supportedFileAttributeViews().contains("posix") && !(currentPermissions = Files.getPosixFilePermissions(hookFilePath, new LinkOption[0])).containsAll(HOOK_FILE_PERMISSIONS)) {
                    Files.setPosixFilePermissions(hookFilePath, HOOK_FILE_PERMISSIONS);
                }
            }
        }
    }

    private String getHookPath(String hookName) {
        return GIT_HOOKS_PATH + "/" + hookName;
    }

    Optional<String> readHook(String hookName) throws IOException {
        Path hookFilePath = Paths.get(this.getHookPath(hookName), new String[0]);
        if (!Files.exists(hookFilePath, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(new String(Files.readAllBytes(hookFilePath)));
    }
}

