/*
 * Decompiled with CFR 0.152.
 */
package nl.adaptivity.xmlutil.serialization.impl;

import javax.xml.namespace.QName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import nl.adaptivity.xmlutil.IterableNamespaceContext;
import nl.adaptivity.xmlutil.serialization.XML;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0002j\u0002`\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lnl/adaptivity/xmlutil/serialization/impl/XmlQNameSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljavax/xml/namespace/QName;", "Lnl/adaptivity/xmlutil/QName;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "xmlutil-serialization"})
@Serializer(forClass=QName.class)
public final class XmlQNameSerializer
implements KSerializer<QName> {
    @NotNull
    public static final XmlQNameSerializer INSTANCE = new XmlQNameSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"javax.xml.namespace.QName", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private XmlQNameSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public QName deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof XML.XmlInput)) {
            throw new SerializationException("QNameXmlSerializer only makes sense in an XML context");
        }
        IterableNamespaceContext namespaceContext2 = ((XML.XmlInput)decoder).getInput().getNamespaceContext().freeze();
        String prefixedName = ((Object)StringsKt.trim((CharSequence)decoder.decodeString())).toString();
        int cIndex = StringsKt.indexOf$default((CharSequence)prefixedName, (char)':', (int)0, (boolean)false, (int)6, null);
        String prefix = null;
        String namespace = null;
        String localPart = null;
        if (cIndex < 0) {
            prefix = "";
            localPart = prefixedName;
            String string = namespaceContext2.getNamespaceURI("");
            if (string == null) {
                string = "";
            }
            namespace = string;
        } else {
            String string = prefixedName.substring(0, cIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            prefix = string;
            String string2 = prefixedName.substring(cIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            localPart = string2;
            String string3 = namespaceContext2.getNamespaceURI(prefix);
            if (string3 == null) {
                throw new SerializationException("Missing namespace for prefix " + prefix + " in QName value");
            }
            namespace = string3;
        }
        return new QName(namespace, localPart, prefix);
    }

    public void serialize(@NotNull Encoder encoder, @NotNull QName value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(encoder instanceof XML.XmlOutput)) {
            throw new SerializationException("QNameXmlSerializer only makes sense in an XML context");
        }
        encoder.encodeString(value.getPrefix() + ':' + value.getLocalPart());
    }
}

