/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.iq80.leveldb.util.Closeables;

public final class SafeListBuilder<T extends Closeable>
implements Closeable {
    private ImmutableList.Builder<T> builder;

    private SafeListBuilder(ImmutableList.Builder<T> builder) {
        this.builder = builder;
    }

    public static final <T extends Closeable> SafeListBuilder<T> builder() {
        return new SafeListBuilder<T>(ImmutableList.builder());
    }

    public ImmutableList.Builder<T> add(T element) {
        return this.builder.add(element);
    }

    public ImmutableList.Builder<T> addAll(Iterable<? extends T> elements) {
        return this.builder.addAll(elements);
    }

    public List<T> build() {
        ImmutableList.Builder<T> b1 = this.builder;
        this.builder = null;
        return b1.build();
    }

    @Override
    public void close() throws IOException {
        ImmutableList.Builder<T> b = this.builder;
        if (b != null) {
            Closeables.closeAll((Iterable<? extends Closeable>)b.build());
        }
    }
}

