/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import org.iq80.leveldb.table.FilterPolicy;
import org.iq80.leveldb.util.Slice;

final class FilterBlockReader {
    private final byte baseLg;
    private final int num;
    private final Slice contents;
    private final int offset;
    private final FilterPolicy filterPolicy;

    FilterBlockReader(FilterPolicy filterPolicy, Slice contents) {
        this.filterPolicy = filterPolicy;
        int n = contents.length();
        int lgAndOffset = 5;
        if (n < 5) {
            this.baseLg = 0;
            this.contents = null;
            this.num = 0;
            this.offset = 0;
            return;
        }
        this.baseLg = contents.getByte(n - 1);
        this.offset = contents.getInt(n - 5);
        if (this.offset > n - 5) {
            this.num = 0;
            this.contents = null;
            return;
        }
        this.num = (n - 5 - this.offset) / 4;
        this.contents = contents;
    }

    public boolean keyMayMatch(long offset1, Slice key) {
        int index = (int)(offset1 >> this.baseLg);
        if (index < this.num) {
            int limit;
            int start = this.contents.getInt(this.offset + index * 4);
            if (start <= (limit = this.contents.getInt(this.offset + index * 4 + 4)) && limit <= this.offset) {
                Slice filter = this.contents.slice(start, limit - start);
                return this.filterPolicy.keyMayMatch(key, filter);
            }
            if (start == limit) {
                return false;
            }
        }
        return true;
    }
}

