/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.iq80.leveldb.table.FilterPolicy;
import org.iq80.leveldb.util.DynamicSliceOutput;
import org.iq80.leveldb.util.IntVector;
import org.iq80.leveldb.util.Slice;

public class FilterBlockBuilder {
    private static final byte FILTER_BASE_LG = 11;
    private static final int FILTER_BASE = 2048;
    private final List<Slice> keys = new ArrayList<Slice>();
    private final DynamicSliceOutput result = new DynamicSliceOutput(32);
    private final IntVector filterOffsets = new IntVector(32);
    private final FilterPolicy policy;

    public FilterBlockBuilder(FilterPolicy policy) {
        this.policy = policy;
    }

    public void addKey(Slice key) {
        this.keys.add(key);
    }

    public void startBlock(long blockOffset) {
        long filterIndex = blockOffset / 2048L;
        Preconditions.checkArgument((filterIndex >= (long)this.filterOffsets.size() ? 1 : 0) != 0);
        while (filterIndex > (long)this.filterOffsets.size()) {
            this.generateFilter();
        }
    }

    private void generateFilter() {
        int numberOfKeys = this.keys.size();
        if (numberOfKeys == 0) {
            this.filterOffsets.add(this.result.size());
            return;
        }
        this.filterOffsets.add(this.result.size());
        byte[] filter = this.policy.createFilter(this.keys);
        this.result.writeBytes(filter);
        this.keys.clear();
    }

    public Slice finish() {
        if (!this.keys.isEmpty()) {
            this.generateFilter();
        }
        int arrayOffset = this.result.size();
        this.filterOffsets.write(this.result);
        this.result.writeInt(arrayOffset);
        this.result.write(11);
        Slice slice = this.result.slice();
        return slice;
    }

    public String name() {
        return this.policy.name();
    }
}

