/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.memenv;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.memenv.FileState;
import org.iq80.leveldb.util.SliceOutput;

class MemSequentialFile
implements SequentialFile {
    private final FileState fileState;
    private boolean closed;
    private int index;

    public MemSequentialFile(FileState fileState) {
        this.fileState = fileState;
    }

    @Override
    public void skip(long n) throws IOException {
        if ((long)this.index > this.fileState.length()) {
            throw new IOException("File position " + this.index + " is greater than file size");
        }
        long available = this.fileState.length() - (long)this.index;
        if (n > available) {
            n = available;
        }
        this.index = (int)((long)this.index + n);
    }

    @Override
    public int read(int atMost, SliceOutput destination) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        byte[] read = this.fileState.read(this.index, atMost);
        if (read != null) {
            this.index += read.length;
            destination.writeBytes(read);
            return read.length;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

