/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.memenv;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.memenv.FileState;
import org.iq80.leveldb.memenv.MemFs;

class MemFile
implements File {
    private final MemFs fs;
    private final String filename;

    private MemFile(MemFs fs, String filename) {
        Preconditions.checkArgument((fs != null ? 1 : 0) != 0, (Object)"fs null");
        Preconditions.checkArgument((filename != null && !filename.isEmpty() ? 1 : 0) != 0, (Object)"empty file name");
        this.fs = fs;
        this.filename = filename;
    }

    static MemFile createMemFile(MemFs fs, String filename) {
        Objects.requireNonNull(filename, "filename");
        String path = filename;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        while (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return new MemFile(fs, path);
    }

    @Override
    public MemFile child(String other) {
        Preconditions.checkArgument((other == null || other.isEmpty() || !other.contains("/") ? 1 : 0) != 0, (String)"Invalid file/directory name %s", (Object)other);
        return MemFile.createMemFile(this.fs, this.filename + '/' + other);
    }

    @Override
    public boolean mkdirs() {
        return this.fs.mkdirs(this);
    }

    @Override
    public String getName() {
        int i = this.filename.lastIndexOf(47);
        return i >= 0 ? this.filename.substring(i + 1) : this.filename;
    }

    @Override
    public MemFile getParentFile() {
        int i = this.filename.lastIndexOf("/");
        return MemFile.createMemFile(this.fs, i > 0 ? this.filename.substring(0, i) : "/");
    }

    @Override
    public String getPath() {
        return this.filename;
    }

    @Override
    public boolean canRead() {
        return this.fs.canRead(this);
    }

    @Override
    public boolean exists() {
        return this.fs.exists(this);
    }

    @Override
    public boolean isDirectory() {
        return this.fs.isDirectory(this);
    }

    @Override
    public boolean isFile() {
        return this.fs.isFile(this);
    }

    @Override
    public long length() {
        return this.fs.getFileState(this).map(FileState::length).orElse(0L);
    }

    @Override
    public boolean delete() {
        return this.fs.delete(this);
    }

    @Override
    public List<File> listFiles() {
        return this.fs.listFiles(this);
    }

    @Override
    public boolean renameTo(File dest) {
        return this.fs.renameTo(this, (MemFile)dest);
    }

    @Override
    public boolean deleteRecursively() {
        return this.fs.deleteRecursively(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemFile memFile = (MemFile)o;
        return Objects.equals(this.filename, memFile.filename);
    }

    public int hashCode() {
        return Objects.hash(this.filename);
    }

    public String toString() {
        return this.filename;
    }
}

