/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.memenv;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.env.DbLock;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.env.NoOpLogger;
import org.iq80.leveldb.env.RandomInputFile;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.memenv.MemFile;
import org.iq80.leveldb.memenv.MemFs;
import org.iq80.leveldb.memenv.MemRandomInputFile;
import org.iq80.leveldb.memenv.MemSequentialFile;
import org.iq80.leveldb.memenv.MemWritableFile;
import org.iq80.leveldb.util.Slices;

public class MemEnv
implements Env {
    private final MemFs fs = new MemFs();

    public static Env createEnv() {
        return new MemEnv();
    }

    @Override
    public long nowMicros() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
    }

    @Override
    public File toFile(String filename) {
        return MemFile.createMemFile(this.fs, filename);
    }

    @Override
    public File createTempDir(String prefix) {
        return this.fs.createTempDir(prefix);
    }

    @Override
    public SequentialFile newSequentialFile(File file) throws IOException {
        return new MemSequentialFile(this.fs.requireFile((MemFile)file));
    }

    @Override
    public RandomInputFile newRandomAccessFile(File file) throws IOException {
        return new MemRandomInputFile(file, this.fs.requireFile((MemFile)file));
    }

    @Override
    public WritableFile newWritableFile(File file) throws IOException {
        return new MemWritableFile(this.fs.getOrCreateFile((MemFile)file));
    }

    @Override
    public WritableFile newAppendableFile(File file) throws IOException {
        return new MemWritableFile(this.fs.getOrCreateFile((MemFile)file));
    }

    @Override
    public void writeStringToFileSync(File file, String content) throws IOException {
        this.fs.getOrCreateFile((MemFile)file).truncate().append(Slices.wrappedBuffer(content.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String readFileToString(File file) throws IOException {
        byte[] read = this.fs.requireFile((MemFile)file).read(0L, (int)file.length());
        if (read == null) {
            throw new IOException("Could not read all the data");
        }
        return new String(read, StandardCharsets.UTF_8);
    }

    @Override
    public Logger newLogger(File loggerFile) throws IOException {
        return new NoOpLogger();
    }

    @Override
    public DbLock tryLock(File file) throws IOException {
        return this.fs.doLock((MemFile)file);
    }
}

