/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.iterator.ASeekingIterator;
import org.iq80.leveldb.iterator.SeekingIterator;

class TwoLevelIterator<T, K, V>
extends ASeekingIterator<K, V> {
    private final Function<T, SeekingIterator<K, V>> blockFunction;
    private Closeable closeableResources;
    private SeekingIterator<K, T> indexIterator;
    private SeekingIterator<K, V> current;

    TwoLevelIterator(SeekingIterator<K, T> indexIterator, Function<T, SeekingIterator<K, V>> blockFunction, Closeable closeableResources) {
        this.indexIterator = indexIterator;
        this.blockFunction = blockFunction;
        this.closeableResources = closeableResources;
    }

    @Override
    protected boolean internalSeekToFirst() {
        if (this.initDataBlock(this.indexIterator.seekToFirst()) && this.current.seekToFirst()) {
            return true;
        }
        return this.skipEmptyDataBlocksForward();
    }

    @Override
    protected boolean internalSeek(K targetKey) {
        if (this.initDataBlock(this.indexIterator.seek(targetKey)) && this.current.seek(targetKey)) {
            return true;
        }
        return this.skipEmptyDataBlocksForward();
    }

    @Override
    protected boolean internalSeekToLast() {
        if (!this.indexIterator.seekToLast()) {
            this.closeAndResetCurrent();
            return false;
        }
        if (this.initDataBlock(true) && this.current.seekToLast()) {
            return true;
        }
        return this.skipEmptyDataBlocksBackward();
    }

    @Override
    protected boolean internalNext(boolean switchDirection) {
        return this.current.next() || this.skipEmptyDataBlocksForward();
    }

    @Override
    protected boolean internalPrev(boolean switchDirection) {
        return this.current.prev() || this.skipEmptyDataBlocksBackward();
    }

    @Override
    protected K internalKey() {
        return this.current.key();
    }

    @Override
    protected V internalValue() {
        return this.current.value();
    }

    private boolean skipEmptyDataBlocksForward() {
        while (this.current == null || !this.current.valid()) {
            if (!this.indexIterator.valid()) {
                this.closeAndResetCurrent();
                return false;
            }
            if (!this.initDataBlock(this.indexIterator.next()) || !this.current.seekToFirst()) continue;
            return true;
        }
        return true;
    }

    private boolean skipEmptyDataBlocksBackward() {
        while (this.current == null || !this.current.valid()) {
            if (!this.indexIterator.valid()) {
                this.closeAndResetCurrent();
                return false;
            }
            if (!this.initDataBlock(this.indexIterator.prev()) || !this.current.seekToLast()) continue;
            return true;
        }
        return true;
    }

    private boolean initDataBlock(boolean valid) {
        this.closeAndResetCurrent();
        if (valid) {
            T blockHandle = this.indexIterator.value();
            this.current = this.blockFunction.apply(blockHandle);
            return true;
        }
        return false;
    }

    public String toString() {
        return "TwoLevelIterator{blockFunction=" + this.blockFunction + ", indexIterator=" + this.indexIterator + ", current=" + this.current + '}';
    }

    private void closeAndResetCurrent() {
        if (this.current != null) {
            try {
                this.current.close();
            }
            catch (IOException e) {
                throw new DBException((Throwable)e);
            }
        }
        this.current = null;
    }

    @Override
    public void internalClose() throws IOException {
        assert (this.closeableResources != null) : "Unexpected multiple calls to close() method";
        try {
            this.closeAndResetCurrent();
            this.indexIterator.close();
            this.indexIterator = null;
        }
        finally {
            this.closeableResources.close();
            this.closeableResources = null;
        }
    }
}

