/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Function;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.iterator.ASeekingIterator;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.SeekingIterator;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.Slice;

public final class MergingIterator
extends ASeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private final List<InternalIterator> iterators;
    private final Comparator<InternalKey> keyComparator;
    private final Comparator<InternalIterator> iteratorComparator;
    private PriorityQueue<InternalIterator> queue;
    private InternalIterator current;

    public MergingIterator(List<InternalIterator> iterators, Comparator<InternalKey> comparator) {
        this.keyComparator = comparator;
        this.iteratorComparator = (o1, o2) -> this.keyComparator.compare((InternalKey)o1.key(), (InternalKey)o2.key());
        this.iterators = iterators;
    }

    private void rebuildQueue(boolean reverse, Function<InternalIterator, Boolean> func) {
        this.queue = new PriorityQueue<InternalIterator>(this.iterators.size(), reverse ? this.iteratorComparator.reversed() : this.iteratorComparator);
        for (InternalIterator iterator : this.iterators) {
            if (!func.apply(iterator).booleanValue()) continue;
            this.queue.add(iterator);
        }
    }

    @Override
    protected boolean internalSeekToFirst() {
        this.rebuildQueue(false, SeekingIterator::seekToFirst);
        this.current = this.queue.poll();
        return this.current != null;
    }

    @Override
    protected boolean internalSeekToLast() {
        this.rebuildQueue(true, SeekingIterator::seekToLast);
        this.current = this.queue.poll();
        return this.current != null;
    }

    @Override
    protected boolean internalSeek(InternalKey targetKey) {
        this.rebuildQueue(false, itr -> itr.seek(targetKey));
        this.current = this.queue.poll();
        return this.current != null;
    }

    @Override
    protected boolean internalNext(boolean switchDirection) {
        if (switchDirection) {
            InternalKey key = (InternalKey)this.key();
            this.rebuildQueue(false, iter -> iter != this.current && iter.seek(key) && (this.keyComparator.compare(key, (InternalKey)iter.key()) != 0 || iter.next()));
        }
        if (this.current.next()) {
            this.queue.add(this.current);
        }
        this.current = this.queue.poll();
        return this.current != null;
    }

    @Override
    protected boolean internalPrev(boolean switchDirection) {
        if (switchDirection) {
            InternalKey key = (InternalKey)this.key();
            this.rebuildQueue(true, iter -> {
                if (iter.seek(key)) {
                    return iter.prev();
                }
                return iter.seekToLast();
            });
        } else if (this.current.prev()) {
            this.queue.add(this.current);
        }
        this.current = this.queue.poll();
        return this.current != null;
    }

    @Override
    protected InternalKey internalKey() {
        return (InternalKey)this.current.key();
    }

    @Override
    protected Slice internalValue() {
        return (Slice)this.current.value();
    }

    @Override
    public void internalClose() throws IOException {
        Closeables.closeAll(this.iterators);
    }
}

