/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.impl.Compaction;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.Level;
import org.iq80.leveldb.impl.LogMonitors;
import org.iq80.leveldb.impl.LogReader;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.Version;
import org.iq80.leveldb.impl.VersionEdit;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.InternalTableIterator;
import org.iq80.leveldb.iterator.MergingIterator;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.SafeListBuilder;
import org.iq80.leveldb.util.Slice;

public class VersionSet {
    private static final int L0_COMPACTION_TRIGGER = 4;
    private final AtomicLong nextFileNumber = new AtomicLong(2L);
    private long manifestFileNumber = 1L;
    private Version current;
    private long lastSequence;
    private long logNumber;
    private long prevLogNumber;
    private final Map<Version, Object> activeVersions = new MapMaker().weakKeys().makeMap();
    private final Options options;
    private final File databaseDir;
    private final TableCache tableCache;
    private final InternalKeyComparator internalKeyComparator;
    private final Env env;
    private LogWriter descriptorLog;
    private final Map<Integer, InternalKey> compactPointers = new TreeMap<Integer, InternalKey>();

    public VersionSet(Options options, File databaseDir, TableCache tableCache, InternalKeyComparator internalKeyComparator, Env env) throws IOException {
        this.options = options;
        this.databaseDir = databaseDir;
        this.tableCache = tableCache;
        this.internalKeyComparator = internalKeyComparator;
        this.env = env;
        this.appendVersion(new Version(this));
        this.initializeIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNeeded() throws IOException {
        File currentFile = this.databaseDir.child(Filename.currentFileName());
        if (!currentFile.exists()) {
            VersionEdit edit = new VersionEdit();
            edit.setComparatorName(this.internalKeyComparator.name());
            edit.setLogNumber(this.prevLogNumber);
            edit.setNextFileNumber(this.nextFileNumber.get());
            edit.setLastSequenceNumber(this.lastSequence);
            try (LogWriter log = Logs.createLogWriter(this.databaseDir.child(Filename.descriptorFileName(this.manifestFileNumber)), this.manifestFileNumber, this.env);){
                this.writeSnapshot(log);
                log.addRecord(edit.encode(), false);
            }
            Filename.setCurrentFile(this.databaseDir, log.getFileNumber(), this.env);
        }
    }

    public void release() throws IOException {
        Set<Version> versions;
        Version t;
        if (this.descriptorLog != null) {
            this.descriptorLog.close();
            this.descriptorLog = null;
        }
        if ((t = this.current) != null) {
            this.current = null;
            t.release();
        }
        if ((versions = this.activeVersions.keySet()).size() > 0) {
            this.options.logger().log("DB closed with %s open snapshots. This could mean your application has a resource leak.", new Object[]{versions.size()});
        }
    }

    private void appendVersion(Version version) {
        Objects.requireNonNull(version, "version is null");
        Preconditions.checkArgument((version != this.current ? 1 : 0) != 0, (Object)"version is the current version");
        Version previous = this.current;
        this.current = version;
        this.activeVersions.put(version, new Object());
        if (previous != null) {
            previous.release();
        }
    }

    public void removeVersion(Version version) {
        boolean removed;
        Objects.requireNonNull(version, "version is null");
        Preconditions.checkArgument((version != this.current ? 1 : 0) != 0, (Object)"version is the current version");
        boolean bl = removed = this.activeVersions.remove(version) != null;
        assert (removed) : "Expected the version to still be in the active set";
    }

    public InternalKeyComparator getInternalKeyComparator() {
        return this.internalKeyComparator;
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    public Version getCurrent() {
        return this.current;
    }

    public long getManifestFileNumber() {
        return this.manifestFileNumber;
    }

    public long getNextFileNumber() {
        return this.nextFileNumber.getAndIncrement();
    }

    public long getLogNumber() {
        return this.logNumber;
    }

    public long getPrevLogNumber() {
        return this.prevLogNumber;
    }

    public MergingIterator iterator(ReadOptions options) throws IOException {
        return this.current.iterator(options);
    }

    public MergingIterator makeInputIterator(Compaction c) throws IOException {
        ReadOptions rOptions = new ReadOptions();
        rOptions.verifyChecksums(this.options.paranoidChecks());
        rOptions.fillCache(false);
        try (SafeListBuilder<InternalIterator> list = SafeListBuilder.builder();){
            for (int which = 0; which < 2; ++which) {
                List<FileMetaData> files = c.input(which);
                if (files.isEmpty()) continue;
                if (c.getLevel() + which == 0) {
                    try (SafeListBuilder<InternalTableIterator> builder = SafeListBuilder.builder();){
                        for (FileMetaData file : files) {
                            builder.add(this.tableCache.newIterator(file, rOptions));
                        }
                        list.add(new MergingIterator(builder.build(), this.internalKeyComparator));
                        continue;
                    }
                }
                list.add(Level.createLevelConcatIterator(this.tableCache, files, this.internalKeyComparator, rOptions));
            }
            MergingIterator mergingIterator = new MergingIterator(list.build(), this.internalKeyComparator);
            return mergingIterator;
        }
    }

    public boolean overlapInLevel(int level, Slice smallestUserKey, Slice largestUserKey) {
        return this.current.overlapInLevel(level, smallestUserKey, largestUserKey);
    }

    public int numberOfFilesInLevel(int level) {
        return this.current.numberOfFilesInLevel(level);
    }

    public long numberOfBytesInLevel(int level) {
        return this.current.numberOfFilesInLevel(level);
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public void setLastSequence(long newLastSequence) {
        Preconditions.checkArgument((newLastSequence >= this.lastSequence ? 1 : 0) != 0, (Object)"Expected newLastSequence to be greater than or equal to current lastSequence");
        this.lastSequence = newLastSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAndApply(VersionEdit edit, ReentrantLock mutex) throws IOException {
        if (edit.getLogNumber() != null) {
            Preconditions.checkArgument((edit.getLogNumber() >= this.logNumber ? 1 : 0) != 0);
            Preconditions.checkArgument((edit.getLogNumber() < this.nextFileNumber.get() ? 1 : 0) != 0);
        } else {
            edit.setLogNumber(this.logNumber);
        }
        if (edit.getPreviousLogNumber() == null) {
            edit.setPreviousLogNumber(this.prevLogNumber);
        }
        edit.setNextFileNumber(this.nextFileNumber.get());
        edit.setLastSequenceNumber(this.lastSequence);
        Version version = new Version(this);
        try (Builder builder = new Builder(this, this.current);){
            builder.apply(edit);
            builder.saveTo(version);
        }
        this.finalizeVersion(version);
        boolean createdNewManifest = false;
        long mFileNumber = this.manifestFileNumber;
        try {
            if (this.descriptorLog == null) {
                edit.setNextFileNumber(this.nextFileNumber.get());
                this.descriptorLog = Logs.createLogWriter(this.databaseDir.child(Filename.descriptorFileName(mFileNumber)), mFileNumber, this.env);
                this.writeSnapshot(this.descriptorLog);
                createdNewManifest = true;
            }
            mutex.unlock();
            try {
                Slice record = edit.encode();
                this.descriptorLog.addRecord(record, true);
                if (createdNewManifest) {
                    Filename.setCurrentFile(this.databaseDir, mFileNumber, this.env);
                }
            }
            finally {
                mutex.lock();
            }
        }
        catch (IOException e) {
            this.options.logger().log("MANIFEST write: %s", new Object[]{e});
            if (createdNewManifest) {
                this.descriptorLog.close();
                this.databaseDir.child(Filename.logFileName(mFileNumber)).delete();
                this.descriptorLog = null;
            }
            throw e;
        }
        this.appendVersion(version);
        this.logNumber = edit.getLogNumber();
        this.prevLogNumber = edit.getPreviousLogNumber();
    }

    private void writeSnapshot(LogWriter log) throws IOException {
        VersionEdit edit = new VersionEdit();
        edit.setComparatorName(this.internalKeyComparator.name());
        edit.setCompactPointers(this.compactPointers);
        edit.addFiles(this.current.getFiles());
        Slice record = edit.encode();
        log.addRecord(record, false);
    }

    public boolean recover() throws IOException {
        String descriptorName = Filename.getCurrentFile(this.databaseDir, this.env);
        File descriptorFile = this.databaseDir.child(descriptorName);
        try (SequentialFile in = this.env.newSequentialFile(descriptorFile);){
            Long nextFileNumber = null;
            Long lastSequence = null;
            Long logNumber = null;
            Long prevLogNumber = null;
            Builder builder = new Builder(this, this.current);
            LogReader reader = new LogReader(in, LogMonitors.throwExceptionMonitor(), true, 0L);
            Slice record = reader.readRecord();
            while (record != null) {
                VersionEdit edit = new VersionEdit(record);
                String editComparator = edit.getComparatorName();
                String userComparator = this.internalKeyComparator.name();
                Preconditions.checkArgument((editComparator == null || editComparator.equals(userComparator) ? 1 : 0) != 0, (String)"Expected user comparator %s to match existing database comparator ", (Object)userComparator, (Object)editComparator);
                builder.apply(edit);
                logNumber = VersionSet.coalesce(edit.getLogNumber(), logNumber);
                prevLogNumber = VersionSet.coalesce(edit.getPreviousLogNumber(), prevLogNumber);
                nextFileNumber = VersionSet.coalesce(edit.getNextFileNumber(), nextFileNumber);
                lastSequence = VersionSet.coalesce(edit.getLastSequenceNumber(), lastSequence);
                record = reader.readRecord();
            }
            ArrayList<String> problems = new ArrayList<String>();
            if (nextFileNumber == null) {
                problems.add("Descriptor does not contain a meta-nextfile entry");
            }
            if (logNumber == null) {
                problems.add("Descriptor does not contain a meta-lognumber entry");
            }
            if (lastSequence == null) {
                problems.add("Descriptor does not contain a last-sequence-number entry");
            }
            if (!problems.isEmpty()) {
                throw new DBException("Corruption: \n\t" + Joiner.on((String)"\n\t").join(problems));
            }
            if (prevLogNumber == null) {
                prevLogNumber = 0L;
            }
            this.markFileNumberUsed(prevLogNumber);
            this.markFileNumberUsed(logNumber);
            Version newVersion = new Version(this);
            builder.saveTo(newVersion);
            builder.close();
            this.finalizeVersion(newVersion);
            this.appendVersion(newVersion);
            this.manifestFileNumber = nextFileNumber;
            this.nextFileNumber.set(nextFileNumber + 1L);
            this.lastSequence = lastSequence;
            this.logNumber = logNumber;
            this.prevLogNumber = prevLogNumber;
            if (this.reuseManifest(descriptorFile)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    void markFileNumberUsed(long number) {
        long current;
        while ((current = this.nextFileNumber.get()) <= number && !this.nextFileNumber.compareAndSet(current, number + 1L)) {
        }
    }

    private boolean reuseManifest(File currentFile) {
        if (!this.options.reuseLogs()) {
            return false;
        }
        Filename.FileInfo fileInfo = Filename.parseFileName(currentFile);
        if (fileInfo == null || fileInfo.getFileType() != Filename.FileType.DESCRIPTOR || currentFile.length() >= this.targetFileSize()) {
            return false;
        }
        Preconditions.checkState((this.descriptorLog == null ? 1 : 0) != 0, (Object)"descriptor log should be null");
        try {
            this.descriptorLog = LogWriter.createWriter(fileInfo.getFileNumber(), this.env.newAppendableFile(currentFile));
        }
        catch (Exception e) {
            assert (this.descriptorLog == null);
            this.options.logger().log("Reuse MANIFEST: %s", new Object[]{e});
            return false;
        }
        this.options.logger().log("Reusing MANIFEST %s", new Object[]{currentFile});
        this.manifestFileNumber = fileInfo.getFileNumber();
        return true;
    }

    private void finalizeVersion(Version version) {
        int bestLevel = -1;
        double bestScore = -1.0;
        for (int level = 0; level < version.numberOfLevels() - 1; ++level) {
            double score;
            if (level == 0) {
                score = 1.0 * (double)version.numberOfFilesInLevel(level) / 4.0;
            } else {
                long levelBytes = 0L;
                for (FileMetaData fileMetaData : version.getFiles(level)) {
                    levelBytes += fileMetaData.getFileSize();
                }
                score = 1.0 * (double)levelBytes / this.maxBytesForLevel(level);
            }
            if (!(score > bestScore)) continue;
            bestLevel = level;
            bestScore = score;
        }
        version.setCompactionLevel(bestLevel);
        version.setCompactionScore(bestScore);
    }

    private static <V> V coalesce(V ... values) {
        for (V value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public List<FileMetaData> getLiveFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Version activeVersion : this.activeVersions.keySet()) {
            builder.addAll((Iterable)activeVersion.getFiles().values());
        }
        return builder.build();
    }

    public long targetFileSize() {
        return this.options.maxFileSize();
    }

    public long maxGrandParentOverlapBytes() {
        return 10L * this.targetFileSize();
    }

    public long expandedCompactionByteSizeLimit() {
        return 25L * this.targetFileSize();
    }

    private double maxBytesForLevel(int level) {
        double result = 1.048576E7;
        while (level > 1) {
            result *= 10.0;
            --level;
        }
        return result;
    }

    public long maxFileSizeForLevel() {
        return this.targetFileSize();
    }

    public long totalFileSize(List<FileMetaData> files) {
        long sum = 0L;
        for (FileMetaData file : files) {
            sum += file.getFileSize();
        }
        return sum;
    }

    public boolean needsCompaction() {
        return this.current.getCompactionScore() >= 1.0 || this.current.getFileToCompact() != null;
    }

    public Compaction compactRange(int level, InternalKey begin, InternalKey end) {
        List<FileMetaData> levelInputs = this.getOverlappingInputs(level, begin, end);
        if (levelInputs.isEmpty()) {
            return null;
        }
        return this.setupOtherInputs(level, levelInputs);
    }

    public Compaction pickCompaction() {
        Object levelInputs;
        int level;
        boolean seekCompaction;
        boolean sizeCompaction = this.current.getCompactionScore() >= 1.0;
        boolean bl = seekCompaction = this.current.getFileToCompact() != null;
        if (sizeCompaction) {
            level = this.current.getCompactionLevel();
            Preconditions.checkState((level >= 0 ? 1 : 0) != 0);
            Preconditions.checkState((level + 1 < 7 ? 1 : 0) != 0);
            levelInputs = new ArrayList();
            for (FileMetaData fileMetaData : this.current.getFiles(level)) {
                if (this.compactPointers.containsKey(level) && this.internalKeyComparator.compare(fileMetaData.getLargest(), this.compactPointers.get(level)) <= 0) continue;
                levelInputs.add(fileMetaData);
                break;
            }
            if (levelInputs.isEmpty()) {
                levelInputs.add(this.current.getFiles(level).get(0));
            }
        } else if (seekCompaction) {
            level = this.current.getFileToCompactLevel();
            levelInputs = ImmutableList.of((Object)this.current.getFileToCompact());
        } else {
            return null;
        }
        if (level == 0) {
            Map.Entry<InternalKey, InternalKey> range = this.getRange(new List[]{levelInputs});
            Preconditions.checkState((!(levelInputs = this.getOverlappingInputs(0, range.getKey(), range.getValue())).isEmpty() ? 1 : 0) != 0);
        }
        return this.setupOtherInputs(level, (List<FileMetaData>)levelInputs);
    }

    private static InternalKey findLargestKey(InternalKeyComparator internalKeyComparator, List<FileMetaData> files) {
        if (files.isEmpty()) {
            return null;
        }
        InternalKey largestKey = files.get(0).getLargest();
        for (FileMetaData file : files) {
            if (internalKeyComparator.compare(file.getLargest(), largestKey) <= 0) continue;
            largestKey = file.getLargest();
        }
        return largestKey;
    }

    private static FileMetaData findSmallestBoundaryFile(InternalKeyComparator internalKeyComparator, List<FileMetaData> levelFiles, InternalKey largestKey) {
        UserComparator userComparator = internalKeyComparator.getUserComparator();
        FileMetaData smallestBoundaryFile = null;
        for (FileMetaData f : levelFiles) {
            if (internalKeyComparator.compare(f.getSmallest(), largestKey) <= 0 || userComparator.compare(f.getSmallest().getUserKey(), largestKey.getUserKey()) != 0 || smallestBoundaryFile != null && internalKeyComparator.compare(f.getSmallest(), smallestBoundaryFile.getSmallest()) >= 0) continue;
            smallestBoundaryFile = f;
        }
        return smallestBoundaryFile;
    }

    static void addBoundaryInputs(InternalKeyComparator internalKeyComparator, List<FileMetaData> levelFiles, List<FileMetaData> compactionFiles) {
        FileMetaData smallestBoundaryFile;
        InternalKey largestKey = VersionSet.findLargestKey(internalKeyComparator, compactionFiles);
        if (largestKey == null) {
            return;
        }
        while ((smallestBoundaryFile = VersionSet.findSmallestBoundaryFile(internalKeyComparator, levelFiles, largestKey)) != null) {
            compactionFiles.add(smallestBoundaryFile);
            largestKey = smallestBoundaryFile.getLargest();
        }
    }

    private Compaction setupOtherInputs(int level, List<FileMetaData> levelInputs) {
        VersionSet.addBoundaryInputs(this.internalKeyComparator, this.current.getFiles(level), levelInputs);
        Map.Entry<InternalKey, InternalKey> range = this.getRange(levelInputs);
        InternalKey smallest = range.getKey();
        InternalKey largest = range.getValue();
        List<FileMetaData> levelUpInputs = this.getOverlappingInputs(level + 1, smallest, largest);
        range = this.getRange(levelInputs, levelUpInputs);
        InternalKey allStart = range.getKey();
        InternalKey allLimit = range.getValue();
        if (!levelUpInputs.isEmpty()) {
            InternalKey newLimit;
            InternalKey newStart;
            List<FileMetaData> expanded1;
            List<FileMetaData> expanded0 = this.getOverlappingInputs(level, allStart, allLimit);
            VersionSet.addBoundaryInputs(this.internalKeyComparator, this.current.getFiles(level), expanded0);
            long levelInputSize = this.totalFileSize(levelInputs);
            long levelUpInputSize = this.totalFileSize(levelUpInputs);
            long expanded0Size = this.totalFileSize(expanded0);
            if (expanded0.size() > levelInputs.size() && levelUpInputSize + expanded0Size < this.expandedCompactionByteSizeLimit() && (expanded1 = this.getOverlappingInputs(level + 1, newStart = (range = this.getRange(expanded0)).getKey(), newLimit = range.getValue())).size() == levelUpInputs.size()) {
                this.options.logger().log("Expanding@%s %s+%s (%s+%s bytes) to %s+%s (%s+%s bytes)", new Object[]{level, levelInputs.size(), levelUpInputs.size(), levelInputSize, levelUpInputSize, expanded0.size(), expanded1.size(), expanded0Size, levelUpInputSize});
                largest = newLimit;
                levelInputs = expanded0;
                levelUpInputs = expanded1;
                range = this.getRange(levelInputs, levelUpInputs);
                allStart = range.getKey();
                allLimit = range.getValue();
            }
        }
        List<FileMetaData> grandparents = level + 2 < 7 ? this.getOverlappingInputs(level + 2, allStart, allLimit) : Collections.emptyList();
        Compaction compaction = new Compaction(this.current, level, this.maxFileSizeForLevel(), levelInputs, levelUpInputs, grandparents);
        this.compactPointers.put(level, largest);
        compaction.getEdit().setCompactPointer(level, largest);
        return compaction;
    }

    List<FileMetaData> getOverlappingInputs(int level, InternalKey begin, InternalKey end) {
        Preconditions.checkArgument((level >= 0 && level <= 7 ? 1 : 0) != 0, (String)"Invalid level value %s", (int)level);
        ArrayList<FileMetaData> inputs = new ArrayList<FileMetaData>();
        Slice userBegin = begin == null ? null : begin.getUserKey();
        Slice userEnd = end == null ? null : end.getUserKey();
        UserComparator userComparator = this.internalKeyComparator.getUserComparator();
        List<FileMetaData> filesInLevel = this.current.getFiles(level);
        for (int i = 0; i < filesInLevel.size(); ++i) {
            FileMetaData fileMetaData = filesInLevel.get(i);
            Slice fileStart = fileMetaData.getSmallest().getUserKey();
            Slice fileLimit = fileMetaData.getLargest().getUserKey();
            if (begin != null && userComparator.compare(fileLimit, userBegin) < 0 || end != null && userComparator.compare(fileStart, userEnd) > 0) continue;
            inputs.add(fileMetaData);
            if (level != 0) continue;
            if (begin != null && userComparator.compare(fileStart, userBegin) < 0) {
                userBegin = fileStart;
                inputs.clear();
                i = -1;
                continue;
            }
            if (end == null || userComparator.compare(fileLimit, userEnd) <= 0) continue;
            userEnd = fileLimit;
            inputs.clear();
            i = -1;
        }
        return inputs;
    }

    private Map.Entry<InternalKey, InternalKey> getRange(List<FileMetaData> ... inputLists) {
        InternalKey smallest = null;
        InternalKey largest = null;
        for (List<FileMetaData> inputList : inputLists) {
            for (FileMetaData fileMetaData : inputList) {
                if (smallest == null) {
                    smallest = fileMetaData.getSmallest();
                    largest = fileMetaData.getLargest();
                    continue;
                }
                if (this.internalKeyComparator.compare(fileMetaData.getSmallest(), smallest) < 0) {
                    smallest = fileMetaData.getSmallest();
                }
                if (this.internalKeyComparator.compare(fileMetaData.getLargest(), largest) <= 0) continue;
                largest = fileMetaData.getLargest();
            }
        }
        return Maps.immutableEntry(smallest, largest);
    }

    public long getMaxNextLevelOverlappingBytes() {
        long result = 0L;
        for (int level = 1; level < 6; ++level) {
            for (FileMetaData fileMetaData : this.current.getFiles(level)) {
                List<FileMetaData> overlaps = this.getOverlappingInputs(level + 1, fileMetaData.getSmallest(), fileMetaData.getLargest());
                long totalSize = 0L;
                for (FileMetaData overlap : overlaps) {
                    totalSize += overlap.getFileSize();
                }
                result = Math.max(result, totalSize);
            }
        }
        return result;
    }

    public CharSequence levelSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("files[ ");
        for (int level = 0; level < 7; ++level) {
            sb.append(" ");
            sb.append(this.current.getFiles(level).size());
        }
        sb.append(" ]");
        return sb;
    }

    private static class Builder
    implements AutoCloseable {
        private final VersionSet versionSet;
        private final Version baseVersion;
        private final List<LevelState> levels;

        private Builder(VersionSet versionSet, Version baseVersion) {
            this.versionSet = versionSet;
            this.baseVersion = baseVersion;
            baseVersion.retain();
            this.levels = new ArrayList<LevelState>(baseVersion.numberOfLevels());
            for (int i = 0; i < baseVersion.numberOfLevels(); ++i) {
                this.levels.add(new LevelState(versionSet.internalKeyComparator));
            }
        }

        public void apply(VersionEdit edit) {
            Integer level;
            for (Map.Entry<Integer, InternalKey> entry : edit.getCompactPointers().entrySet()) {
                level = entry.getKey();
                InternalKey internalKey = entry.getValue();
                this.versionSet.compactPointers.put(level, internalKey);
            }
            for (Map.Entry<Integer, InternalKey> entry : edit.getDeletedFiles().entries()) {
                level = entry.getKey();
                Long fileNumber = (Long)((Object)entry.getValue());
                this.levels.get(level).deletedFiles.add(fileNumber);
            }
            for (Map.Entry<Integer, InternalKey> entry : edit.getNewFiles().entries()) {
                level = entry.getKey();
                FileMetaData fileMetaData = (FileMetaData)((Object)entry.getValue());
                int allowedSeeks = (int)(fileMetaData.getFileSize() / 16384L);
                if (allowedSeeks < 100) {
                    allowedSeeks = 100;
                }
                fileMetaData.setAllowedSeeks(allowedSeeks);
                this.levels.get(level).deletedFiles.remove(fileMetaData.getNumber());
                this.levels.get(level).addedFiles.add(fileMetaData);
            }
        }

        public void saveTo(Version version) throws IOException {
            FileMetaDataBySmallestKey cmp = new FileMetaDataBySmallestKey(this.versionSet.internalKeyComparator);
            for (int level = 0; level < this.baseVersion.numberOfLevels(); ++level) {
                SortedSet addedFiles;
                ImmutableList baseFiles = this.baseVersion.getFiles(level);
                if (baseFiles == null) {
                    baseFiles = ImmutableList.of();
                }
                if ((addedFiles = this.levels.get(level).addedFiles) == null) {
                    addedFiles = ImmutableSortedSet.of();
                }
                ArrayList sortedFiles = new ArrayList(baseFiles.size() + addedFiles.size());
                sortedFiles.addAll(baseFiles);
                sortedFiles.addAll(addedFiles);
                Collections.sort(sortedFiles, cmp);
                for (FileMetaData fileMetaData : sortedFiles) {
                    this.maybeAddFile(version, level, fileMetaData);
                }
                version.assertNoOverlappingFiles(level);
            }
        }

        private void maybeAddFile(Version version, int level, FileMetaData fileMetaData) throws IOException {
            if (!this.levels.get(level).deletedFiles.contains(fileMetaData.getNumber())) {
                List<FileMetaData> files = version.getFiles(level);
                if (level > 0 && !files.isEmpty()) {
                    boolean filesOverlap;
                    boolean bl = filesOverlap = this.versionSet.internalKeyComparator.compare(files.get(files.size() - 1).getLargest(), fileMetaData.getSmallest()) >= 0;
                    if (filesOverlap) {
                        throw new IOException(String.format("Compaction is obsolete: Overlapping files %s and %s in level %s", files.get(files.size() - 1).getNumber(), fileMetaData.getNumber(), level));
                    }
                }
                version.addFile(level, fileMetaData);
            }
        }

        @Override
        public void close() {
            this.baseVersion.release();
        }

        private static class LevelState {
            private final SortedSet<FileMetaData> addedFiles;
            private final Set<Long> deletedFiles = new HashSet<Long>();

            public LevelState(InternalKeyComparator internalKeyComparator) {
                this.addedFiles = new TreeSet<FileMetaData>(new FileMetaDataBySmallestKey(internalKeyComparator));
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("LevelState");
                sb.append("{addedFiles=").append(this.addedFiles);
                sb.append(", deletedFiles=").append(this.deletedFiles);
                sb.append('}');
                return sb.toString();
            }
        }

        private static class FileMetaDataBySmallestKey
        implements Comparator<FileMetaData> {
            private final InternalKeyComparator internalKeyComparator;

            private FileMetaDataBySmallestKey(InternalKeyComparator internalKeyComparator) {
                this.internalKeyComparator = internalKeyComparator;
            }

            @Override
            public int compare(FileMetaData f1, FileMetaData f2) {
                return ComparisonChain.start().compare((Object)f1.getSmallest(), (Object)f2.getSmallest(), (Comparator)this.internalKeyComparator).compare(f1.getNumber(), f2.getNumber()).result();
            }
        }
    }
}

