/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.impl.LogChunkType;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class LogWriter
implements Closeable {
    private static final byte[] SA = new byte[7];
    private final WritableFile writableFile;
    private final long fileNumber;
    private final AtomicBoolean closed = new AtomicBoolean();
    private int blockOffset;

    private LogWriter(long fileNumber, WritableFile file) {
        Objects.requireNonNull(file, "file is null");
        Preconditions.checkArgument((fileNumber >= 0L ? 1 : 0) != 0, (Object)"fileNumber is negative");
        this.fileNumber = fileNumber;
        this.writableFile = file;
    }

    private LogWriter(long fileNumber, WritableFile file, long destinationLength) {
        this(fileNumber, file);
        this.blockOffset = (int)(destinationLength % 32768L);
    }

    public static LogWriter createWriter(long fileNumber, WritableFile writableFile) {
        return new LogWriter(fileNumber, writableFile);
    }

    public static LogWriter createWriter(long fileNumber, WritableFile writableFile, long destinationLength) {
        return new LogWriter(fileNumber, writableFile, destinationLength);
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        this.writableFile.close();
    }

    public long getFileNumber() {
        return this.fileNumber;
    }

    public void addRecord(Slice record, boolean force) throws IOException {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Log has been closed");
        SliceInput sliceInput = record.input();
        boolean begin = true;
        do {
            int fragmentLength;
            boolean end;
            int bytesAvailableInBlock;
            int bytesRemainingInBlock;
            Preconditions.checkState(((bytesRemainingInBlock = 32768 - this.blockOffset) >= 0 ? 1 : 0) != 0);
            if (bytesRemainingInBlock < 7) {
                if (bytesRemainingInBlock > 0) {
                    this.writableFile.append(new Slice(SA, 0, bytesRemainingInBlock));
                }
                this.blockOffset = 0;
                bytesRemainingInBlock = 32768 - this.blockOffset;
            }
            Preconditions.checkState(((bytesAvailableInBlock = bytesRemainingInBlock - 7) >= 0 ? 1 : 0) != 0);
            if (sliceInput.available() > bytesAvailableInBlock) {
                end = false;
                fragmentLength = bytesAvailableInBlock;
            } else {
                end = true;
                fragmentLength = sliceInput.available();
            }
            LogChunkType type = begin && end ? LogChunkType.FULL : (begin ? LogChunkType.FIRST : (end ? LogChunkType.LAST : LogChunkType.MIDDLE));
            this.writeChunk(type, sliceInput.readBytes(fragmentLength));
            begin = false;
        } while (sliceInput.isReadable());
        if (force) {
            this.writableFile.force();
        }
    }

    private void writeChunk(LogChunkType type, Slice slice) throws IOException {
        Preconditions.checkArgument((slice.length() <= 65535 ? 1 : 0) != 0, (String)"length %s is larger than two bytes", (int)slice.length());
        Preconditions.checkArgument((this.blockOffset + 7 <= 32768 ? 1 : 0) != 0);
        Slice header = LogWriter.newLogRecordHeader(type, slice, slice.length());
        this.writableFile.append(header);
        this.writableFile.append(slice);
        this.blockOffset += 7 + slice.length();
    }

    private static Slice newLogRecordHeader(LogChunkType type, Slice slice, int length) {
        int crc = Logs.getChunkChecksum(type.getPersistentId(), slice.getRawArray(), slice.getRawOffset(), length);
        Slice header = Slices.allocate(7);
        SliceOutput sliceOutput = header.output();
        sliceOutput.writeInt(crc);
        sliceOutput.writeByte((byte)(length & 0xFF));
        sliceOutput.writeByte((byte)(length >>> 8));
        sliceOutput.writeByte((byte)type.getPersistentId());
        return header;
    }

    public String toString() {
        return "LogWriter{writableFile=" + this.writableFile + ", fileNumber=" + this.fileNumber + '}';
    }
}

