/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.fileenv.EnvImpl;
import org.iq80.leveldb.impl.DbImpl;

public class Iq80DBFactory
implements DBFactory {
    public static final String VERSION;
    public static final Iq80DBFactory factory;

    public DB open(File path, Options options) throws IOException {
        Objects.requireNonNull(path, "path is null");
        return new DbImpl(options, path.getAbsolutePath(), EnvImpl.createEnv());
    }

    public void destroy(File path, Options options) throws IOException {
        Objects.requireNonNull(path, "path is null");
        Env env = EnvImpl.createEnv();
        DbImpl.destroyDB(env.toFile(path.getAbsolutePath()), env);
    }

    public void repair(File path, Options options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("iq80 leveldb version %s", VERSION);
    }

    public static byte[] bytes(String value) {
        return value == null ? null : value.getBytes(StandardCharsets.UTF_8);
    }

    public static String asString(byte[] value) {
        return value == null ? null : new String(value, StandardCharsets.UTF_8);
    }

    static {
        String v = "unknown";
        InputStream is = Iq80DBFactory.class.getResourceAsStream("version.txt");
        try {
            v = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).readLine();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
        VERSION = v;
        factory = new Iq80DBFactory();
    }
}

