/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.fileenv.ByteBufferSupport;
import org.iq80.leveldb.util.Slice;

class MMWritableFile
implements WritableFile {
    private final File file;
    private final int pageSize;
    private MappedByteBuffer mappedByteBuffer;
    private int fileOffset;

    private MMWritableFile(File file, int pageSize, MappedByteBuffer map) {
        this.file = file;
        this.pageSize = pageSize;
        this.fileOffset = 0;
        this.mappedByteBuffer = map;
    }

    public static WritableFile open(File file, int pageSize) throws IOException {
        return new MMWritableFile(file, pageSize, Files.map((File)file, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)pageSize));
    }

    @Override
    public void append(Slice data) throws IOException {
        this.ensureCapacity(data.length());
        data.getBytes(0, this.mappedByteBuffer);
    }

    private void destroyMappedByteBuffer() {
        if (this.mappedByteBuffer != null) {
            this.fileOffset += this.mappedByteBuffer.position();
            this.unmap();
        }
        this.mappedByteBuffer = null;
    }

    private void ensureCapacity(int bytes) throws IOException {
        if (this.mappedByteBuffer == null) {
            this.mappedByteBuffer = this.openNewMap(this.fileOffset, Math.max(bytes, this.pageSize));
        }
        if (this.mappedByteBuffer.remaining() < bytes) {
            this.fileOffset += this.mappedByteBuffer.position();
            this.unmap();
            int sizeToGrow = Math.max(bytes, this.pageSize);
            this.mappedByteBuffer = this.openNewMap(this.fileOffset, sizeToGrow);
        }
    }

    private MappedByteBuffer openNewMap(int fileOffset, int sizeToGrow) throws IOException {
        try (FileChannel cha = this.openChannel();){
            MappedByteBuffer mappedByteBuffer = cha.map(FileChannel.MapMode.READ_WRITE, fileOffset, sizeToGrow);
            return mappedByteBuffer;
        }
    }

    private FileChannel openChannel() throws FileNotFoundException {
        return new RandomAccessFile(this.file, "rw").getChannel();
    }

    private void unmap() {
        ByteBufferSupport.unmap(this.mappedByteBuffer);
    }

    @Override
    public void force() throws IOException {
        if (this.mappedByteBuffer != null) {
            this.mappedByteBuffer.force();
        }
    }

    @Override
    public void close() throws IOException {
        this.destroyMappedByteBuffer();
        try (FileChannel cha = this.openChannel();){
            cha.truncate(this.fileOffset);
        }
    }

    public String toString() {
        return "MMWritableFile{file=" + this.file + '}';
    }
}

