/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Objects;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.env.DbLock;
import org.iq80.leveldb.util.Closeables;

class FileLock
implements DbLock {
    private final File lockFile;
    private final FileChannel channel;
    private final java.nio.channels.FileLock lock;

    private FileLock(File lockFile, FileChannel channel, java.nio.channels.FileLock lock) {
        this.lockFile = lockFile;
        this.channel = channel;
        this.lock = lock;
    }

    public static FileLock tryLock(File lockFile) throws IOException {
        Objects.requireNonNull(lockFile, "lockFile is null");
        FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
        try {
            java.nio.channels.FileLock lock = channel.tryLock();
            if (lock == null) {
                throw new IOException(String.format("Unable to acquire lock on '%s'", lockFile.getAbsolutePath()));
            }
            return new FileLock(lockFile, channel, lock);
        }
        catch (Exception e) {
            Closeables.closeQuietly(channel);
            throw new IOException(String.format("Unable to acquire lock on '%s'", lockFile.getAbsolutePath()), e);
        }
    }

    @Override
    public boolean isValid() {
        return this.lock.isValid();
    }

    @Override
    public void release() {
        try (FileChannel closeMe = this.channel;){
            this.lock.release();
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbLock");
        sb.append("{lockFile=").append(this.lockFile);
        sb.append(", lock=").append(this.lock);
        sb.append('}');
        return sb.toString();
    }
}

