/*
 * Decompiled with CFR 0.152.
 */
package com.swinglayoutbuilder.constraintlayout;

import com.swinglayoutbuilder.constraintlayout.ComponentRect;
import com.swinglayoutbuilder.constraintlayout.ConstraintLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ConstraintLayoutGroup
extends Component {
    private final List<Component> children = new ArrayList<Component>();
    private final ComponentRect rectangle = new ComponentRect();
    private final ConstraintLayout owner;

    public ConstraintLayoutGroup(ConstraintLayout owner) {
        this.owner = owner;
    }

    public ConstraintLayoutGroup addComponent(Component component) {
        this.children.add(component);
        return this;
    }

    public ComponentRect getRect() {
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (Component component : this.children) {
            ComponentRect rect = this.owner.getRect(component);
            if (rect.getX() < minX) {
                minX = rect.getX();
            }
            if (rect.getY() < minY) {
                minY = rect.getY();
            }
            if (rect.getX2() > maxX) {
                maxX = rect.getX2();
            }
            if (rect.getY2() <= maxY) continue;
            maxY = rect.getY2();
        }
        this.rectangle.reset(minX, minY, maxX - minX, maxY - minY);
        return this.rectangle;
    }

    public List<Component> getChildren() {
        return this.children;
    }
}

