/*
 * Decompiled with CFR 0.152.
 */
package com.swinglayoutbuilder.constraintlayout;

import com.swinglayoutbuilder.constraintlayout.ComponentRect;
import com.swinglayoutbuilder.constraintlayout.Constraint;
import com.swinglayoutbuilder.constraintlayout.ConstraintLayoutGroup;
import com.swinglayoutbuilder.constraintlayout.Edge;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConstraintLayout
implements LayoutManager2 {
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private final Map<Component, ComponentRect> componentRectangleMap = new HashMap<Component, ComponentRect>();
    private final Set<ConstraintLayoutGroup> groups = new HashSet<ConstraintLayoutGroup>();
    private final Insets layoutMargin = new Insets(0, 0, 0, 0);

    public ConstraintLayoutGroup createGroup() {
        ConstraintLayoutGroup newGroup = new ConstraintLayoutGroup(this);
        this.groups.add(newGroup);
        return newGroup;
    }

    public ConstraintLayout addConstraint(Constraint ... constraints) {
        for (Constraint c : constraints) {
            this.constraints.add(c);
        }
        return this;
    }

    public ConstraintLayout setMargin(int top, int left, int bottom, int right) {
        this.layoutMargin.set(top, left, bottom, right);
        return this;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        this.runCalculations(parent, SizeType.MAX);
        return this.calculateBounds(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.runCalculations(parent, SizeType.PREF);
        return this.calculateBounds(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.runCalculations(parent, SizeType.MIN);
        return this.calculateBounds(parent);
    }

    private Dimension calculateBounds(Container parent) {
        int maxX = 0;
        int maxY = 0;
        for (Component component : parent.getComponents()) {
            ComponentRect rect = this.getRect(component);
            maxX = Math.max(maxX, rect.getX2());
            maxY = Math.max(maxY, rect.getY2());
        }
        return new Dimension(maxX += this.layoutMargin.left + this.layoutMargin.right, maxY += this.layoutMargin.top + this.layoutMargin.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.runCalculations(parent, SizeType.PREF);
        for (Component component : parent.getComponents()) {
            ComponentRect rect = this.getRect(component);
            component.setBounds(rect.getX() + this.layoutMargin.left, rect.getY() + this.layoutMargin.top, rect.getWidth(), rect.getHeight());
        }
    }

    private void runCalculations(Container parent, SizeType sizeType) {
        for (Component component : parent.getComponents()) {
            Dimension sizeDimension;
            ComponentRect rect = this.getRect(component);
            if (sizeType == SizeType.MIN) {
                sizeDimension = component.getMinimumSize();
            } else if (sizeType == SizeType.MAX) {
                sizeDimension = component.getMaximumSize();
            } else if (sizeType == SizeType.PREF) {
                sizeDimension = component.getPreferredSize();
            } else {
                throw new RuntimeException("Size type is not implemented " + (Object)((Object)sizeType));
            }
            rect.reset(0, 0, sizeDimension.width, sizeDimension.height);
        }
        ComponentRect parentComponentRect = this.getRect(parent);
        parentComponentRect.reset(0, 0, parent.getWidth() - this.layoutMargin.left - this.layoutMargin.right, parent.getHeight() - this.layoutMargin.top - this.layoutMargin.bottom);
        for (Constraint constraint : this.constraints) {
            ComponentRect anchorComponentRect = this.getRect(constraint.getAnchorComponent());
            ComponentRect componentRect = this.getRect(constraint.getComponent());
            int position = this.getPosition(anchorComponentRect, constraint.getAnchorComponent(), constraint.getAnchorEdge());
            this.setPosition(componentRect, constraint.getComponent(), constraint.getEdge(), position + constraint.getOffset());
        }
    }

    ComponentRect getRect(Component component) {
        if (component instanceof ConstraintLayoutGroup && this.groups.contains(component)) {
            ConstraintLayoutGroup group = (ConstraintLayoutGroup)component;
            return group.getRect();
        }
        ComponentRect rect = this.componentRectangleMap.get(component);
        if (rect == null) {
            rect = new ComponentRect();
            this.componentRectangleMap.put(component, rect);
        }
        return rect;
    }

    private int getPosition(ComponentRect rect, Component component, Edge edge) {
        switch (edge) {
            case LEFT: {
                return rect.getX();
            }
            case RIGHT: {
                return rect.getX2();
            }
            case TOP: {
                return rect.getY();
            }
            case BOTTOM: {
                return rect.getY2();
            }
            case WIDTH: {
                return rect.getWidth();
            }
            case HEIGHT: {
                return rect.getHeight();
            }
            case HOR_CENTER: {
                return rect.getX() + rect.getWidth() / 2;
            }
            case VER_CENTER: {
                return rect.getY() + rect.getHeight() / 2;
            }
            case BASELINE: {
                return component.getBaseline(rect.getWidth(), rect.getHeight()) + rect.getY();
            }
        }
        throw new RuntimeException("Unknown edge " + (Object)((Object)edge));
    }

    private void setPosition(ComponentRect rect, Component component, Edge edge, int value) {
        switch (edge) {
            case LEFT: {
                rect.setX(value);
                break;
            }
            case RIGHT: {
                rect.setX2(value);
                break;
            }
            case TOP: {
                rect.setY(value);
                break;
            }
            case BOTTOM: {
                rect.setY2(value);
                break;
            }
            case WIDTH: {
                rect.setWidth(value);
                break;
            }
            case HEIGHT: {
                rect.setHeight(value);
                break;
            }
            case HOR_CENTER: {
                rect.moveX(value - rect.getWidth() / 2);
                break;
            }
            case VER_CENTER: {
                rect.moveY(value - rect.getHeight() / 2);
                break;
            }
            case BASELINE: {
                int baseLine = component.getBaseline(rect.getWidth(), rect.getHeight()) + rect.getY();
                int diff = value - baseLine;
                rect.moveY(rect.getY() + diff);
                break;
            }
            default: {
                throw new RuntimeException("Unknown edge " + (Object)((Object)edge));
            }
        }
    }

    private static enum SizeType {
        MIN,
        MAX,
        PREF;

    }
}

