/*
 * Decompiled with CFR 0.152.
 */
package com.swinglayoutbuilder.constraintlayout;

public class ComponentRect {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean x1Set = false;
    private boolean y1Set = false;
    private boolean x2Set = false;
    private boolean y2Set = false;

    public void reset(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.x2Set = false;
        this.y2Set = false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void moveX(int value) {
        this.x = value;
    }

    public void moveY(int value) {
        this.y = value;
    }

    public void setX(int x) {
        if (this.x2Set) {
            int lastX2 = this.getX2();
            this.width = lastX2 - x;
        }
        this.x = x;
        this.x1Set = true;
        this.normalize();
    }

    public void setY(int y) {
        if (this.y2Set) {
            int lastY2 = this.getY2();
            this.height = lastY2 - y;
        }
        this.y = y;
        this.y1Set = true;
        this.normalize();
    }

    public void setWidth(int width) {
        if (this.x2Set) {
            int lastX2 = this.getX2();
            this.x = lastX2 - width;
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (this.y2Set) {
            int lastY2 = this.getY2();
            this.y = lastY2 - height;
        }
        this.height = height;
    }

    public int getX2() {
        return this.x + this.width;
    }

    public int getY2() {
        return this.y + this.height;
    }

    public void setX2(int value) {
        if (this.x1Set) {
            this.width = value - this.x;
        } else {
            this.x = value - this.width;
        }
        this.x2Set = true;
    }

    public void setY2(int value) {
        if (this.y1Set) {
            this.height = value - this.y;
        } else {
            this.y = value - this.height;
        }
        this.y2Set = true;
    }

    public void normalize() {
        if (this.width < 0) {
            this.width = -this.width;
            this.x -= this.width;
        }
        if (this.height < 0) {
            this.height = -this.height;
            this.y -= this.height;
        }
    }
}

