/*
 * Decompiled with CFR 0.152.
 */
package com.swinglayoutbuilder;

import com.swinglayoutbuilder.AbstractBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FormLayoutBuilder
extends AbstractBuilder {
    private boolean labelLeftAlignment = true;
    private List<Pair> currentColumn;
    private final List<List<Pair>> columns = new ArrayList<List<Pair>>();
    private int gapLabelToComponent = 5;
    private int gapBetweenRows = 5;
    private int gapBetweenColumns = 20;
    private Function<String, Component> labelFactory = JLabel::new;
    private Component currentComponent;

    protected FormLayoutBuilder(Container container) {
        super(container);
        this.newColumn();
    }

    public FormLayoutBuilder newColumn() {
        this.currentColumn = new ArrayList<Pair>();
        this.columns.add(this.currentColumn);
        return this;
    }

    public FormLayoutBuilder labelFactory(Function<String, Component> labelFactoryFunction) {
        this.labelFactory = labelFactoryFunction;
        return this;
    }

    public FormLayoutBuilder gapLabelToComponent(int gap) {
        this.gapLabelToComponent = gap;
        return this;
    }

    public FormLayoutBuilder gapBetweenRows(int gap) {
        this.gapBetweenRows = gap;
        return this;
    }

    public FormLayoutBuilder gapBetweenColumns(int gap) {
        this.gapBetweenColumns = gap;
        return this;
    }

    public FormLayoutBuilder labelsLeftAlignment() {
        this.labelLeftAlignment = true;
        return this;
    }

    public FormLayoutBuilder labelsRightAlignment() {
        this.labelLeftAlignment = false;
        return this;
    }

    public FormLayoutBuilder add(String labelTitle, Component component) {
        Component label = this.createLabel(labelTitle);
        this.currentComponent = component;
        return this.add(label, component);
    }

    public FormLayoutBuilder add(Component component) {
        this.currentComponent = component;
        return this.add((Component)null, component);
    }

    public FormLayoutBuilder add(Component label, Component component) {
        this.currentColumn.add(new Pair(label, component));
        return this;
    }

    public FormLayoutBuilder preferredSize(int width, int height) {
        this.currentComponent.setPreferredSize(new Dimension(width, height));
        return this;
    }

    public FormLayoutBuilder minimumSize(int width, int height) {
        this.currentComponent.setMinimumSize(new Dimension(width, height));
        return this;
    }

    public FormLayoutBuilder maximumSize(int width, int height) {
        this.currentComponent.setMaximumSize(new Dimension(width, height));
        return this;
    }

    private Component createLabel(String labelTitle) {
        return this.labelFactory.apply(labelTitle);
    }

    @Override
    public Container finish() {
        GridBagLayout layout = new GridBagLayout();
        this.container.setLayout(layout);
        int column = 0;
        for (List<Pair> currentColumn : this.columns) {
            int row = 0;
            if (column != 0) {
                JPanel paddingPanel = new JPanel(false);
                paddingPanel.setPreferredSize(new Dimension(this.gapBetweenColumns, 1));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = column * 3 - 1;
                c.gridy = 0;
                c.weightx = 0.1;
                c.fill = 1;
                this.container.add((Component)paddingPanel, c);
            }
            for (Pair pair : currentColumn) {
                if (pair.label != null) {
                    int rowTopInsets = row > 0 ? this.gapBetweenRows : 0;
                    GridBagConstraints c = new GridBagConstraints();
                    c.fill = 0;
                    c.gridx = column * 3;
                    c.gridy = row;
                    c.anchor = this.labelLeftAlignment ? 512 : 768;
                    c.insets = new Insets(rowTopInsets, 0, 0, this.gapLabelToComponent);
                    this.container.add(pair.label, c);
                    c = new GridBagConstraints();
                    c.gridx = column * 3 + 1;
                    c.gridy = row;
                    c.anchor = 512;
                    c.insets = new Insets(rowTopInsets, 0, 0, 0);
                    c.fill = 0;
                    this.container.add(pair.field, c);
                } else {
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = column * 3;
                    c.gridy = row;
                    c.gridwidth = 2;
                    c.anchor = 512;
                    c.insets = new Insets(0, 0, 0, 0);
                    c.fill = 0;
                    this.container.add(pair.field, c);
                }
                ++row;
            }
            ++column;
        }
        return this.container;
    }

    private static class Pair {
        Component label;
        Component field;

        public Pair(Component label, Component field) {
            this.label = label;
            this.field = field;
        }
    }
}

